/*
 * Decompiled with CFR 0.152.
 */
package ljfa.glassshards.handlers;

import ljfa.glassshards.Config;
import ljfa.glassshards.api.GlassType;
import ljfa.glassshards.api.IShatterableGlass;
import ljfa.glassshards.glass.GlassRegistry;
import ljfa.glassshards.glass.ModGlassHandler;
import ljfa.glassshards.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HarvestDropsHandler {
    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        if (event.getWorld().field_72995_K || event.isSilkTouching()) {
            return;
        }
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (block instanceof IShatterableGlass) {
            HarvestDropsHandler.addDropForType(event, ((IShatterableGlass)block).getGlassType(event.getWorld(), event.getPos(), state));
        } else {
            ModGlassHandler handler = GlassRegistry.get(block);
            if (handler != null) {
                if (!event.getDrops().isEmpty()) {
                    if (handler.shouldRemoveDrop(state)) {
                        event.getDrops().clear();
                    } else {
                        return;
                    }
                }
                handler.addShardsDrop(event);
            }
        }
    }

    public static void addDropForType(BlockEvent.HarvestDropsEvent event, GlassType gtype) {
        if (gtype != null) {
            float chance = gtype.getMultiplier() * HarvestDropsHandler.getChanceFromFortune(event.getFortuneLevel());
            if (event.getWorld().field_73012_v.nextFloat() <= chance) {
                int meta = gtype.isStained() ? gtype.getColor().func_176765_a() : 16;
                event.getDrops().add(new ItemStack((Item)ModItems.glass_shards, 1, meta));
            }
        }
    }

    public static float getChanceFromFortune(int fortune) {
        return Math.min(Config.shardsChance + (float)fortune * Config.shardsFortuneChance, 1.0f);
    }
}

