/*
 * Decompiled with CFR 0.152.
 */
package ljfa.glassshards;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.relauncher.Side;
import ljfa.glassshards.Config;
import ljfa.glassshards.ModRecipes;
import ljfa.glassshards.compat.ChiselGlassHelper;
import ljfa.glassshards.compat.EnderIOGlassHelper;
import ljfa.glassshards.compat.MFRGlassHelper;
import ljfa.glassshards.compat.ThaumcraftCompat;
import ljfa.glassshards.compat.ThermalExpCompat;
import ljfa.glassshards.compat.TinkersGlassHelper;
import ljfa.glassshards.glass.GlassRegistry;
import ljfa.glassshards.handlers.BreakSpeedHandler;
import ljfa.glassshards.handlers.HarvestDropsHandler;
import ljfa.glassshards.items.ModItems;
import ljfa.glassshards.render.TransparentItemRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="glass_shards", name="Glass Shards", version="1.5.2", guiFactory="ljfa.glassshards.gui.GsGuiFactory")
public class GlassShards {
    @Mod.Instance(value="glass_shards")
    public static GlassShards instance;
    public static final Logger logger;
    public static Item.ToolMaterial toolMatGlass;
    public boolean isChiselCorrectVersion;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.loadConfig(event.getSuggestedConfigurationFile());
        toolMatGlass = EnumHelper.addToolMaterial((String)"GLASS", (int)2, (int)Config.swordDurability, (float)4.0f, (float)2.0f, (int)5);
        ModItems.preInit();
        toolMatGlass.setRepairItem(new ItemStack((Item)ModItems.glass_shards, 1, 16));
        if (Loader.isModLoaded((String)"chisel")) {
            if (new ComparableVersion(((ModContainer)Loader.instance().getIndexedModList().get("chisel")).getVersion()).compareTo(new ComparableVersion("2.4")) >= 0) {
                this.isChiselCorrectVersion = true;
            } else {
                logger.warn("The Chisel compatibility requires at least version 2.4");
                this.isChiselCorrectVersion = false;
            }
        } else {
            this.isChiselCorrectVersion = false;
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModRecipes.init();
        MinecraftForge.EVENT_BUS.register((Object)new HarvestDropsHandler());
        if (Config.incrBreakSpeed) {
            MinecraftForge.EVENT_BUS.register((Object)new BreakSpeedHandler());
        }
        if (Config.renderTransparent && event.getSide() == Side.CLIENT) {
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.glass_shards, (IItemRenderer)new TransparentItemRenderer());
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.glass_sword, (IItemRenderer)new TransparentItemRenderer());
        }
        if (Loader.isModLoaded((String)"EnderIO")) {
            EnderIOGlassHelper.addRecipes();
        }
        if (Config.tePulverizer && Loader.isModLoaded((String)"ThermalExpansion")) {
            ThermalExpCompat.addRecipes();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GlassRegistry.registerAll();
        this.initCompatModules();
    }

    private void initCompatModules() {
        if (Config.chiselEnable && this.isChiselCorrectVersion) {
            ChiselGlassHelper.init();
        }
        if (Loader.isModLoaded((String)"TConstruct")) {
            if (Config.tinkersEnable) {
                TinkersGlassHelper.init();
            }
            if (Config.tinkersMeltShards) {
                TinkersGlassHelper.addSmelteryRecipe();
            }
        }
        if (Config.mfrEnable && Loader.isModLoaded((String)"MineFactoryReloaded")) {
            MFRGlassHelper.init();
        }
        if (Loader.isModLoaded((String)"EnderIO") && Config.eioDropShards) {
            EnderIOGlassHelper.init();
        }
        if (Config.thaumAspects && Loader.isModLoaded((String)"Thaumcraft")) {
            ThaumcraftCompat.addAspects();
        }
    }

    static {
        logger = LogManager.getLogger((String)"Glass Shards");
    }
}

