/*
 * Decompiled with CFR 0.152.
 */
package ljfa.glassshards.compat;

import ljfa.glassshards.Config;
import ljfa.glassshards.GlassShards;
import ljfa.glassshards.api.GlassType;
import ljfa.glassshards.glass.GlassRegistry;
import ljfa.glassshards.glass.ModGlassHandler;
import net.minecraft.block.Block;

public class ChiselGlassHelper {
    public static void init() {
        int i;
        String[] chiselStainedGlass = new String[]{"white", "yellow", "lightgray", "brown"};
        String[] chiselStainedPane = new String[]{"white", "magenta", "yellow", "pink", "lightgray", "purple", "brown", "red"};
        for (i = 0; i < chiselStainedGlass.length; ++i) {
            GlassRegistry.addHandler("chisel:stained_glass_" + chiselStainedGlass[i], (ModGlassHandler)new ChiselStainedGlassHandler(i));
        }
        for (i = 0; i < chiselStainedPane.length; ++i) {
            GlassRegistry.addHandler("chisel:stained_glass_pane_" + chiselStainedPane[i], (ModGlassHandler)new ChiselStainedPaneHandler(i));
        }
        GlassShards.logger.info("Successfully loaded Chisel compatibility.");
    }

    public static class ChiselStainedPaneHandler
    extends ModGlassHandler {
        private final int arrayIndex;

        public ChiselStainedPaneHandler(int arrayIndex) {
            this.arrayIndex = arrayIndex;
        }

        @Override
        public GlassType getType(Block block, int meta) {
            int color = this.arrayIndex << 1 | meta >> 3;
            return new GlassType(0.375f, true, color);
        }

        @Override
        public boolean shouldRemoveDrop(Block block, int meta) {
            return Config.chiselFixPaneDrops;
        }
    }

    public static class ChiselStainedGlassHandler
    extends ModGlassHandler {
        private final int arrayIndex;

        public ChiselStainedGlassHandler(int arrayIndex) {
            this.arrayIndex = arrayIndex;
        }

        @Override
        public GlassType getType(Block block, int meta) {
            int color = this.arrayIndex << 2 | meta >> 2;
            return new GlassType(1.0f, true, color);
        }
    }
}

