/*
 * Decompiled with CFR 0.152.
 */
package ljfa.glassshards.glass;

import cpw.mods.fml.common.registry.GameData;
import java.util.HashMap;
import java.util.Map;
import ljfa.glassshards.GlassShards;
import ljfa.glassshards.glass.ModGlassHandler;
import ljfa.glassshards.glass.SimpleGlassHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.material.Material;

public class GlassRegistry {
    private static final Map<Block, ModGlassHandler> handlerMap = new HashMap<Block, ModGlassHandler>();

    public static void addHandler(Block block, ModGlassHandler handler) {
        handlerMap.put(block, handler);
        GlassShards.logger.trace("Added glass handler for {}", new Object[]{Block.field_149771_c.func_148750_c((Object)block)});
    }

    public static void addHandler(String blockname, ModGlassHandler handler) {
        if (!Block.field_149771_c.func_148741_d(blockname)) {
            throw new IllegalArgumentException("Could not find block \"" + blockname + "\"");
        }
        GlassRegistry.addHandler((Block)Block.field_149771_c.func_82594_a(blockname), handler);
    }

    public static ModGlassHandler get(Block block) {
        return handlerMap.get(block);
    }

    public static Map<Block, ModGlassHandler> getHandlerMap() {
        return handlerMap;
    }

    public static void registerAll() {
        int counter = 0;
        for (Object obj : GameData.getBlockRegistry()) {
            if (!(obj instanceof Block)) continue;
            Block block = (Block)obj;
            if (block instanceof BlockGlass) {
                GlassRegistry.addHandler(block, (ModGlassHandler)SimpleGlassHandler.blockInstance);
                ++counter;
                continue;
            }
            if (block instanceof BlockStainedGlass) {
                GlassRegistry.addHandler(block, (ModGlassHandler)SimpleGlassHandler.stainedBlockInstance);
                ++counter;
                continue;
            }
            if (block instanceof BlockStainedGlassPane) {
                GlassRegistry.addHandler(block, (ModGlassHandler)SimpleGlassHandler.stainedPaneInstance);
                ++counter;
                continue;
            }
            if (!(block instanceof BlockPane) || block.func_149688_o() != Material.field_151592_s) continue;
            GlassRegistry.addHandler(block, (ModGlassHandler)SimpleGlassHandler.paneInstance);
            ++counter;
        }
        GlassShards.logger.info("Added {} blocks to the GlassRegistry", new Object[]{counter});
    }
}

