/*
 * Decompiled with CFR 0.152.
 */
package ljfa.glassshards;

import cpw.mods.fml.common.registry.GameRegistry;
import ljfa.glassshards.Config;
import ljfa.glassshards.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModRecipes {
    public static final String[] dyes = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};

    public static void init() {
        ModRecipes.addOredict();
        ModRecipes.addCrafting();
        ModRecipes.addSmelting();
    }

    private static void addOredict() {
        OreDictionary.registerOre((String)"dustGlass", (ItemStack)new ItemStack((Item)ModItems.glass_shards, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"shardsGlass", (ItemStack)new ItemStack((Item)ModItems.glass_shards, 1, Short.MAX_VALUE));
        for (int i = 0; i < 16; ++i) {
            OreDictionary.registerOre((String)("dustGlass" + dyes[i]), (ItemStack)new ItemStack((Item)ModItems.glass_shards, 1, i));
            OreDictionary.registerOre((String)("shardsGlass" + dyes[i]), (ItemStack)new ItemStack((Item)ModItems.glass_shards, 1, i));
        }
    }

    private static void addCrafting() {
        int i;
        if (Config.recipesRecolor) {
            for (i = 0; i < 16; ++i) {
                ItemStack shards = new ItemStack((Item)ModItems.glass_shards, 1, 16);
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.glass_shards, 8, i), new Object[]{"SSS", "SDS", "SSS", Character.valueOf('S'), shards, Character.valueOf('D'), "dye" + dyes[i]}));
            }
        }
        if (Config.recipeUncolor) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.glass_shards, 8, 16), new Object[]{"SSS", "SGS", "SSS", Character.valueOf('S'), "shardsGlass", Character.valueOf('G'), Items.field_151016_H}));
        }
        if (Config.enableSword) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ModItems.glass_sword, new Object[]{"S", "S", "|", Character.valueOf('S'), new ItemStack((Item)ModItems.glass_shards, 1, 16), Character.valueOf('|'), "stickWood"}));
            for (i = 0; i < 16; ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Color", (byte)i);
                ItemStack sword = new ItemStack((Item)ModItems.glass_sword);
                sword.func_77982_d(tag);
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(sword, new Object[]{"S", "S", "|", Character.valueOf('S'), new ItemStack((Item)ModItems.glass_shards, 1, i), Character.valueOf('|'), "stickWood"}));
            }
        }
    }

    private static void addSmelting() {
        if (Config.recipesFurnace) {
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ModItems.glass_shards, 1, 16), (ItemStack)new ItemStack(Blocks.field_150359_w), (float)0.05f);
            for (int i = 0; i < 16; ++i) {
                GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ModItems.glass_shards, 1, i), (ItemStack)new ItemStack((Block)Blocks.field_150399_cn, 1, i), (float)0.05f);
            }
        }
    }
}

