/*
 * Decompiled with CFR 0.152.
 */
package ljfa.glassshards.compat;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.versioning.ComparableVersion;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import ljfa.glassshards.Config;
import ljfa.glassshards.GlassShards;
import ljfa.glassshards.ModRecipes;
import ljfa.glassshards.api.GlassType;
import ljfa.glassshards.glass.GlassRegistry;
import ljfa.glassshards.glass.ModGlassHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;

public class EnderIOGlassHelper {
    public static final int clear_meta = 1;
    public static final int enlightened_meta = 3;
    public static final int dark_meta = 5;

    public static void init() {
        GlassRegistry.addHandler("EnderIO:blockFusedQuartz", new ModGlassHandler(){

            @Override
            public void addShardsDrop(BlockEvent.HarvestDropsEvent event) {
                block3: {
                    block2: {
                        super.addShardsDrop(event);
                        if (event.blockMetadata != 3) break block2;
                        for (int i = 0; i < 4; ++i) {
                            event.drops.add(new ItemStack(Items.field_151114_aO));
                        }
                        break block3;
                    }
                    if (event.blockMetadata != 5) break block3;
                    for (int i = 0; i < 4; ++i) {
                        event.drops.add(new ItemStack(Items.field_151100_aR, 1, 0));
                    }
                }
            }

            @Override
            public GlassType getType(Block block, int meta) {
                if (meta == 1 || meta == 3 || meta == 5) {
                    return new GlassType(1.0f);
                }
                return null;
            }

            @Override
            public boolean shouldRemoveDrop(Block block, int meta) {
                return meta == 1 || meta == 3 || meta == 5;
            }
        });
        GlassShards.logger.info("Successfully loaded EnderIO glass compatibility.");
    }

    public static void addRecipes() {
        if (Config.eioSagMill) {
            FMLInterModComms.sendMessage((String)"EnderIO", (String)"recipe:sagmill", (String)("<recipeGroup name=\"EnderIO\">" + EnderIOGlassHelper.getRecipeXML("SagShards") + "</recipeGroup>"));
            StringBuilder msg = new StringBuilder("<recipeGroup name=\"GlassShards\">");
            String template = EnderIOGlassHelper.getRecipeXML("SagStainedShards");
            for (int i = 0; i < 16; ++i) {
                msg.append(String.format(template, ModRecipes.dyes[i], i));
            }
            msg.append(EnderIOGlassHelper.getRecipeXML("SagSand")).append("</recipeGroup>");
            FMLInterModComms.sendMessage((String)"EnderIO", (String)"recipe:sagmill", (String)msg.toString());
            FMLInterModComms.sendMessage((String)"EnderIO", (String)"recipe:sagmill", (String)EnderIOGlassHelper.getRecipeXML("SagGrindingBall"));
        }
        if (Config.eioAlloySmelter) {
            boolean isEnderIO23;
            boolean bl = isEnderIO23 = new ComparableVersion(((ModContainer)Loader.instance().getIndexedModList().get("EnderIO")).getVersion()).compareTo(new ComparableVersion("1.7.10-2.3")) >= 0;
            if (isEnderIO23) {
                GlassShards.logger.debug("We have EnderIO >= 2.3, adding Dark Clear Glass recipe");
            } else {
                GlassShards.logger.debug("We don't have EnderIO >= 2.3");
            }
            String msg = "<recipeGroup name=\"GlassShards\">" + EnderIOGlassHelper.getRecipeXML("SmelterClearGlass");
            if (isEnderIO23) {
                msg = msg + EnderIOGlassHelper.getRecipeXML("SmelterDarkGlass");
            }
            msg = msg + "</recipeGroup>";
            FMLInterModComms.sendMessage((String)"EnderIO", (String)"recipe:alloysmelter", (String)msg);
        }
    }

    private static String getRecipeXML(String name) {
        try {
            return Resources.toString((URL)Resources.getResource((String)("assets/glass_shards/EnderIORecipes/" + name + ".xml")), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

