/*
 * Decompiled with CFR 0.152.
 */
package ljfa.glassshards.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ljfa.glassshards.Config;
import ljfa.glassshards.api.GlassType;
import ljfa.glassshards.api.IShatterableGlass;
import ljfa.glassshards.glass.GlassRegistry;
import ljfa.glassshards.glass.ModGlassHandler;
import ljfa.glassshards.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;

public class HarvestDropsHandler {
    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        if (event.world.field_72995_K || event.isSilkTouching) {
            return;
        }
        Block block = event.block;
        int meta = event.blockMetadata;
        if (block instanceof IShatterableGlass) {
            HarvestDropsHandler.addDropForType(event, ((IShatterableGlass)block).getType(block, meta));
        } else {
            ModGlassHandler handler = GlassRegistry.get(block);
            if (handler != null) {
                if (!event.drops.isEmpty()) {
                    if (handler.shouldRemoveDrop(block, meta)) {
                        event.drops.clear();
                    } else {
                        return;
                    }
                }
                handler.addShardsDrop(event);
            }
        }
    }

    public static void addDropForType(BlockEvent.HarvestDropsEvent event, GlassType gtype) {
        if (gtype != null) {
            float chance = gtype.getMultiplier() * HarvestDropsHandler.getChanceFromFortune(event.fortuneLevel);
            if (event.world.field_73012_v.nextFloat() <= chance) {
                int meta = gtype.isStained() ? gtype.getColor() : 16;
                event.drops.add(new ItemStack((Item)ModItems.glass_shards, 1, meta));
            }
        }
    }

    public static float getChanceFromFortune(int fortune) {
        return Math.min(Config.shardsChance + (float)fortune * Config.shardsFortuneChance, 1.0f);
    }
}

