/*
 * Decompiled with CFR 0.152.
 */
package com.rolandoislas.multihotbar.util;

import com.rolandoislas.multihotbar.data.Config;
import invtweaks.InvTweaks;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.IOUtils;

public class InvTweaksHelper {
    private static int disableTicks = 0;
    private static String initialRefillValue = "";

    public static void addDelay() {
        if (!InvTweaksHelper.invTweaksLoaded()) {
            return;
        }
        disableTicks = 80;
    }

    private static boolean invTweaksLoaded() {
        return Loader.isModLoaded((String)"inventorytweaks");
    }

    public static void tick() {
        if (!InvTweaksHelper.invTweaksLoaded()) {
            return;
        }
        if (disableTicks > 0) {
            if (initialRefillValue.isEmpty()) {
                InvTweaksHelper.setAutoRefill(false);
            }
            --disableTicks;
        } else if (!initialRefillValue.isEmpty()) {
            InvTweaksHelper.setAutoRefill(initialRefillValue.equals("true"));
            initialRefillValue = "";
        }
    }

    private static void setAutoRefill(boolean autorefill) {
        if (!InvTweaksHelper.invTweaksLoaded()) {
            return;
        }
        File invConfig = new File(Config.config.getConfigFile().getParent(), "InvTweaks.cfg");
        try {
            FileInputStream in = new FileInputStream(invConfig);
            String stringConfig = IOUtils.toString((InputStream)in);
            in.close();
            if (stringConfig.isEmpty()) {
                return;
            }
            if (initialRefillValue.isEmpty()) {
                initialRefillValue = String.valueOf(stringConfig.contains("enableAutoRefill=true"));
            }
            stringConfig = stringConfig.replace("enableAutoRefill=true", "enableAutoRefill=" + autorefill);
            stringConfig = stringConfig.replace("enableAutoRefill=false", "enableAutoRefill=" + autorefill);
            FileOutputStream out = new FileOutputStream(invConfig);
            IOUtils.write((String)stringConfig, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            InvTweaks.getConfigManager().getConfig().refreshProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reset() {
        disableTicks = 0;
        if (!initialRefillValue.isEmpty()) {
            InvTweaksHelper.setAutoRefill(initialRefillValue.equals("true"));
            initialRefillValue = "";
        }
    }
}

