/*
 * Decompiled with CFR 0.152.
 */
package com.rolandoislas.multihotbar;

import com.rolandoislas.multihotbar.HotbarLogic;
import com.rolandoislas.multihotbar.data.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class HotBarRenderer
extends Gui {
    private static final int HOTBAR_WIDTH = 182;
    private static final int HOTBAR_HEIGHT = 22;
    private static final int SELECTOR_SIZE = 24;
    public static int tooltipTicks = 128;
    private final ResourceLocation WIDGETS;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private boolean renderPosted = true;

    public HotBarRenderer() {
        this.WIDGETS = new ResourceLocation("minecraft", "textures/gui/widgets.png");
    }

    public void render(RenderGameOverlayEvent event) {
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) || !event.isCancelable() || HotbarLogic.shouldShowDefault()) {
            return;
        }
        event.setCanceled(true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (Config.numberOfHotbars == 1) {
            this.drawSingle(0);
        } else if (Config.numberOfHotbars == 2) {
            this.drawDouble(0);
        } else if (Config.numberOfHotbars == 3) {
            this.drawDouble(0);
            this.drawSingle(2);
        } else if (Config.numberOfHotbars == 4) {
            this.drawDouble(0);
            this.drawDouble(2);
        }
        this.drawSelection();
        this.drawItems();
        this.drawTooltip();
        if (Minecraft.func_71410_x().field_71439_g != null && !((ItemStack)Minecraft.func_71410_x().field_71439_g.field_71071_by.field_184439_c.get(0)).func_190926_b()) {
            this.drawOffhandSlot();
            this.drawOffhandItem();
        }
    }

    private void drawOffhandItem() {
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        ItemStack item = (ItemStack)this.minecraft.field_71439_g.field_71071_by.field_184439_c.get(0);
        int[] coords = this.getHotbarCoords(0);
        int x = coords[0] - 24 - 2;
        int y = coords[1] + 3;
        this.minecraft.func_175599_af().func_180450_b(item, x, y);
        this.minecraft.func_175599_af().func_175030_a(this.minecraft.field_71466_p, item, x, y);
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    private void drawOffhandSlot() {
        int[] coords = this.getHotbarCoords(0);
        this.minecraft.func_110434_K().func_110577_a(this.WIDGETS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.minecraft.field_71456_v.func_73729_b(coords[0] - 24 - 5, coords[1], 24, 23, 22, 22);
    }

    private void drawTooltip() {
        if (tooltipTicks > 0) {
            --tooltipTicks;
        }
        int[] coords = this.getHotbarCoords(Config.numberOfHotbars >= 3 ? 2 : 0);
        ItemStack item = this.minecraft.field_71439_g.field_71071_by.func_70448_g();
        if (item.func_190926_b() || tooltipTicks == 0) {
            return;
        }
        ScaledResolution scaledResolution = new ScaledResolution(this.minecraft);
        int x = scaledResolution.func_78326_a() / 2 - this.minecraft.field_71466_p.func_78256_a(item.func_82833_r()) / 2;
        int y = coords[1] - 37 + (this.minecraft.field_71442_b.func_78755_b() ? 0 : 14);
        int color = (int)((float)tooltipTicks * 256.0f / 10.0f);
        int n = color = color > 255 ? 255 : color;
        if (color > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            this.minecraft.field_71466_p.func_175063_a(item.func_82833_r(), (float)x, (float)y, 0xFFFFFF + (color << 24));
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private void drawItems() {
        for (int i = 0; i < Config.numberOfHotbars; ++i) {
            this.drawItems(i, HotbarLogic.hotbarOrder[i]);
        }
    }

    private void drawSelection() {
        int slot = this.minecraft.field_71439_g.field_71071_by.field_70461_c;
        int index = HotbarLogic.hotbarIndex;
        int[] coords = this.getHotbarCoords(index);
        int x = coords[0];
        int y = coords[1];
        this.minecraft.func_110434_K().func_110577_a(this.WIDGETS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.field_73735_i += 100.0f;
        this.minecraft.field_71456_v.func_73729_b(-1 + x + 20 * slot, y - 1, 0, 22, 24, 24);
    }

    private void drawSingle(int index) {
        int[] coords = this.getHotbarCoords(index);
        this.drawHotbar(coords[0], coords[1]);
    }

    private void drawDouble(int index) {
        for (int i = index; i < index + 2; ++i) {
            int[] coords = this.getHotbarCoords(i);
            this.drawHotbar(coords[0], coords[1]);
        }
    }

    private int[] getHotbarCoords(int index) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ScaledResolution scaledResolution = new ScaledResolution(minecraft);
        int[] coords = new int[2];
        if (Config.numberOfHotbars == 1) {
            coords[0] = scaledResolution.func_78326_a() / 2 - 91;
            coords[1] = scaledResolution.func_78328_b() - 22 * (index + 1);
        } else if (Config.numberOfHotbars == 2 || Config.numberOfHotbars == 4) {
            coords[0] = scaledResolution.func_78326_a() / 2 - 182 * (index == 0 || index == 2 ? 1 : 0);
            coords[1] = scaledResolution.func_78328_b() - 22 * (index == 0 || index == 1 ? 1 : 2);
        } else if (Config.numberOfHotbars == 3) {
            coords[0] = (int)((double)(scaledResolution.func_78326_a() / 2) - 182.0 * (index == 2 ? 0.5 : (double)(index != 1 ? 1 : 0)));
            coords[1] = scaledResolution.func_78328_b() - 22 * (index == 2 ? 2 : 1);
        }
        return coords;
    }

    private int getXForSlot(int index, int slot) {
        int[] coords = this.getHotbarCoords(index);
        int x = coords[0] + 3 + 16 * slot + 4 * slot;
        return x;
    }

    private int getYForSlot(int index) {
        int[] coords = this.getHotbarCoords(index);
        int y = coords[1] + 3;
        return y;
    }

    private void drawHotbar(int x, int y) {
        this.minecraft.func_110434_K().func_110577_a(this.WIDGETS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.minecraft.field_71456_v.func_73729_b(x, y, 0, 0, 182, 22);
    }

    private void drawItems(int hotbarIndex, int slotIndex) {
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        for (int i = slotIndex * 9; i < slotIndex * 9 + 9; ++i) {
            ItemStack item = this.minecraft.field_71439_g.field_71071_by.func_70301_a(i);
            if (item.func_190926_b()) continue;
            int itemX = this.getXForSlot(hotbarIndex, i - slotIndex * 9);
            int itemY = this.getYForSlot(hotbarIndex);
            float pickupAnimation = item.func_190921_D() - 1;
            if (pickupAnimation > 0.0f) {
                GlStateManager.func_179094_E();
                float scale = 1.0f + pickupAnimation / 5.0f;
                GlStateManager.func_179109_b((float)(itemX + 8), (float)(itemY + 12), (float)0.0f);
                GlStateManager.func_179152_a((float)(1.0f / scale), (float)(scale + 0.0f), (float)1.0f);
                GlStateManager.func_179109_b((float)(-(itemX + 8)), (float)(-(itemY + 12)), (float)0.0f);
            }
            this.minecraft.func_175599_af().func_180450_b(item, itemX, itemY);
            if (pickupAnimation > 0.0f) {
                GlStateManager.func_179121_F();
            }
            this.minecraft.func_175599_af().func_175030_a(this.minecraft.field_71466_p, item, itemX, itemY);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        this.shiftOverlayUp(event);
    }

    private void shiftOverlayUp(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) && !this.renderPosted) {
            GL11.glPopMatrix();
            this.renderPosted = true;
        }
        if (!HotbarLogic.shouldShowDefault() && Config.numberOfHotbars > 2 && this.isElementToShift(event.getType())) {
            if (!this.renderPosted) {
                GL11.glPopMatrix();
            }
            this.renderPosted = false;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-22.0f, (float)0.0f);
        }
    }

    public void renderOverlayEventPost(RenderGameOverlayEvent.Post event) {
        this.shiftOverlayDown(event);
    }

    private void shiftOverlayDown(RenderGameOverlayEvent.Post event) {
        if (!HotbarLogic.shouldShowDefault() && Config.numberOfHotbars > 2 && this.isElementToShift(event.getType())) {
            this.renderPosted = true;
            GL11.glPopMatrix();
        }
    }

    public void renderOverlayEvent(RenderGameOverlayEvent event) {
        this.render(event);
    }

    private boolean isElementToShift(RenderGameOverlayEvent.ElementType type) {
        return type == RenderGameOverlayEvent.ElementType.CHAT || type == RenderGameOverlayEvent.ElementType.HEALTH || type == RenderGameOverlayEvent.ElementType.AIR || type == RenderGameOverlayEvent.ElementType.ARMOR || type == RenderGameOverlayEvent.ElementType.EXPERIENCE || type == RenderGameOverlayEvent.ElementType.FOOD || type == RenderGameOverlayEvent.ElementType.HEALTHMOUNT || type == RenderGameOverlayEvent.ElementType.JUMPBAR;
    }
}

