/*
 * Decompiled with CFR 0.152.
 */
package com.rolandoislas.multihotbar;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.rolandoislas.multihotbar.HotBarRenderer;
import com.rolandoislas.multihotbar.MultiHotbar;
import com.rolandoislas.multihotbar.data.Config;
import com.rolandoislas.multihotbar.data.KeyBindings;
import com.rolandoislas.multihotbar.data.WorldJson;
import com.rolandoislas.multihotbar.util.InventoryHelper;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class HotbarLogic {
    public static int hotbarIndex = 0;
    public static int[] hotbarOrder = new int[4];
    private static boolean showDefault = false;
    private static WorldJson[] worldJsonArray;
    private String worldAddress;
    private ArrayList<Integer> pickupSlot = new ArrayList();
    private boolean isWorldLocal;
    private List<ItemStack> inventory;
    private static int inventoryReorderDelayTicks;
    private int pickedUpAmountThisTick = 0;
    private int waitForItemTicks = 0;
    private static ConcurrentHashMap<Integer, Integer> ignoreSlots;

    static boolean shouldShowDefault() {
        boolean isSpectator = Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_175149_v();
        return showDefault || isSpectator;
    }

    private static void setShowDefault(boolean showDefault) {
        HotbarLogic.showDefault = showDefault;
    }

    public void mouseEvent(MouseEvent event) {
        if (HotbarLogic.shouldShowDefault()) {
            return;
        }
        if (event.getDwheel() != 0) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (event.getDwheel() < 0) {
                if (KeyBindings.scrollModifier.func_151470_d()) {
                    HotbarLogic.moveSelectionToNextHotbar();
                } else if (player.field_71071_by.field_70461_c < InventoryPlayer.func_70451_h() - 1) {
                    ++player.field_71071_by.field_70461_c;
                } else {
                    player.field_71071_by.field_70461_c = 0;
                    HotbarLogic.moveSelectionToNextHotbar();
                }
            } else if (KeyBindings.scrollModifier.func_151470_d()) {
                this.moveSelectionToPreviousHotbar();
            } else if (player.field_71071_by.field_70461_c > 0) {
                --player.field_71071_by.field_70461_c;
            } else {
                player.field_71071_by.field_70461_c = InventoryPlayer.func_70451_h() - 1;
                this.moveSelectionToPreviousHotbar();
            }
            event.setCanceled(true);
            this.resetTooltipTicks();
        }
    }

    private void moveSelectionToPreviousHotbar() {
        HotbarLogic.moveSelection(false);
    }

    private static void moveSelection(boolean forward) {
        if (Config.numberOfHotbars == 1) {
            return;
        }
        int previousIndex = hotbarIndex;
        hotbarIndex = (hotbarIndex += forward ? 1 : -1) < 0 ? Config.numberOfHotbars - 1 : hotbarIndex;
        hotbarIndex = hotbarIndex >= Config.numberOfHotbars ? 0 : hotbarIndex;
        InventoryHelper.swapHotbars(0, hotbarOrder[hotbarIndex]);
        int orderFirst = hotbarOrder[previousIndex];
        HotbarLogic.hotbarOrder[previousIndex] = hotbarOrder[hotbarIndex];
        HotbarLogic.hotbarOrder[HotbarLogic.hotbarIndex] = orderFirst;
    }

    private static void moveSelectionToNextHotbar() {
        HotbarLogic.moveSelection(true);
    }

    public void keyPressed(InputEvent.KeyInputEvent event) {
        if (KeyBindings.showDefaultHotbar.func_151468_f()) {
            HotbarLogic.setShowDefault(!HotbarLogic.shouldShowDefault());
            Minecraft.func_71410_x().field_71474_y.field_92117_D = HotbarLogic.shouldShowDefault();
        }
        if (HotbarLogic.shouldShowDefault()) {
            return;
        }
        int slot = KeyBindings.isHotbarKeyDown();
        int currentItem = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c;
        if (slot > -1 && KeyBindings.scrollModifier.func_151470_d() && slot < Config.numberOfHotbars) {
            HotbarLogic.moveSelectionToHotbar(slot);
        } else if (slot > -1 && currentItem == slot && Config.numberOfHotbars > 1) {
            HotbarLogic.moveSelectionToNextHotbar();
        } else if (slot > -1) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c = slot;
            if (!Config.relativeHotbarKeys) {
                HotbarLogic.moveSelectionToHotbar(0);
            }
        }
        if (slot > -1) {
            this.resetTooltipTicks();
        }
    }

    private void resetTooltipTicks() {
        HotBarRenderer.tooltipTicks = 128;
    }

    public static void moveSelectionToHotbar(int index) {
        while (hotbarIndex != index) {
            HotbarLogic.moveSelectionToNextHotbar();
        }
    }

    private static void reset(boolean resetCurrentItem) {
        HotbarLogic.setShowDefault(false);
        HotbarLogic.updateTooltips();
        hotbarIndex = 0;
        for (int i = 0; i < 4; ++i) {
            HotbarLogic.hotbarOrder[i] = i;
        }
        try {
            if (resetCurrentItem) {
                Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void reset() {
        HotbarLogic.reset(true);
    }

    private void save() {
        String path = Config.config.getConfigFile().getAbsolutePath().replace("cfg", "json");
        try {
            boolean found = false;
            if (worldJsonArray != null) {
                for (WorldJson worldJson : worldJsonArray) {
                    if (!worldJson.getId().equals(this.getWorldId())) continue;
                    found = true;
                    worldJson.setIndex(hotbarIndex);
                    worldJson.setOrder(hotbarOrder);
                    break;
                }
            }
            if (!found || worldJsonArray == null) {
                worldJsonArray = worldJsonArray == null ? new WorldJson[1] : Arrays.copyOf(worldJsonArray, worldJsonArray.length + 1);
                int index = worldJsonArray.length - 1;
                HotbarLogic.worldJsonArray[index] = new WorldJson();
                worldJsonArray[index].setId(this.getWorldId());
                worldJsonArray[index].setIndex(hotbarIndex);
                worldJsonArray[index].setOrder(hotbarOrder);
            }
            Gson gson = new Gson();
            FileWriter writer = new FileWriter(path);
            String json = gson.toJson((Object)worldJsonArray);
            writer.write(json);
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void load() {
        block5: {
            String path = Config.config.getConfigFile().getAbsolutePath().replace("cfg", "json");
            try {
                Gson gson = new Gson();
                JsonReader reader = new JsonReader((Reader)new FileReader(path));
                worldJsonArray = (WorldJson[])gson.fromJson(reader, WorldJson[].class);
                if (worldJsonArray != null) {
                    for (WorldJson worldJson : worldJsonArray) {
                        if (worldJson.getId().equals(this.getWorldId())) {
                            HotbarLogic.reset(false);
                            hotbarIndex = worldJson.getIndex();
                            hotbarOrder = worldJson.getOrder();
                            break block5;
                        }
                        HotbarLogic.reset();
                    }
                    break block5;
                }
                HotbarLogic.reset();
            }
            catch (FileNotFoundException ignore) {
                HotbarLogic.reset();
            }
        }
    }

    private static void updateTooltips() {
        Minecraft.func_71410_x().field_71474_y.field_92117_D = HotbarLogic.shouldShowDefault();
    }

    private String getWorldId() {
        String id;
        if (this.isWorldLocal) {
            World world = Minecraft.func_71410_x().func_71401_C().func_130014_f_();
            id = world.func_72912_H().func_76063_b() + world.func_72912_H().func_76065_j() + world.func_72860_G().func_75765_b().getAbsolutePath();
        } else {
            id = this.worldAddress;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(id.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte anArray : array) {
                sb.append(Integer.toHexString(anArray & 0xFF | 0x100).substring(1, 3));
            }
            id = sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return id;
    }

    private int getFirstEmptyStack() {
        for (int i = 0; i < Config.numberOfHotbars; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = hotbarOrder[i] * 9 + j;
                ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(index);
                if (!stack.func_190926_b()) continue;
                return index;
            }
        }
        return -1;
    }

    public void pickupEvent(EntityItemPickupEvent event) {
        ItemStack stack;
        if (HotbarLogic.shouldShowDefault() || Config.relativeHotbarPickups) {
            return;
        }
        if (event.getEntityPlayer() != null && Minecraft.func_71410_x().field_71439_g != null && event.getEntityPlayer().func_110124_au() != Minecraft.func_71410_x().field_71439_g.func_110124_au()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        int slot = this.getFirstCompatibleStack(event.getItem().func_92059_d());
        if (slot >= 0 && ((stack = player.field_71071_by.func_70301_a(slot)).func_190926_b() || stack.func_190916_E() + event.getItem().func_92059_d().func_190916_E() <= stack.func_77976_d())) {
            return;
        }
        slot = this.getFirstEmptyStackVanilla(this.pickedUpAmountThisTick);
        if (slot < 0) {
            return;
        }
        if (slot == this.getFirstEmptyStack()) {
            return;
        }
        this.pickupSlot.add(slot);
        HotbarLogic.addInventoryReorderDelay(5);
        ++this.pickedUpAmountThisTick;
    }

    private int getFirstEmptyStackVanilla(int skip) {
        NonNullList mainInventory = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a;
        for (int i = 0; i < mainInventory.size(); ++i) {
            if (!((ItemStack)mainInventory.get(i)).func_190926_b() || skip-- != 0) continue;
            return i;
        }
        return -1;
    }

    private int getFirstCompatibleStack(ItemStack itemStack) {
        for (int i = 0; i < Config.numberOfHotbars; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = hotbarOrder[i] * 9 + j;
                ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(index);
                if (stack.func_190926_b() || !stack.func_77985_e() || !stack.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack) || stack.func_190916_E() >= stack.func_77976_d()) continue;
                return index;
            }
        }
        return -1;
    }

    private void reorderPickedupItem() {
        if (HotbarLogic.shouldShowDefault() || Config.relativeHotbarPickups) {
            return;
        }
        this.pickedUpAmountThisTick = 0;
        if (inventoryReorderDelayTicks > 0) {
            --inventoryReorderDelayTicks;
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.pickupSlot.isEmpty()) {
            return;
        }
        if (this.waitForItemTicks >= 40) {
            try {
                this.pickupSlot.remove(0);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                MultiHotbar.logger.error((Object)e);
            }
            this.waitForItemTicks = 0;
            return;
        }
        ++this.waitForItemTicks;
        if (player.field_71071_by.func_70301_a(this.pickupSlot.get(0).intValue()).func_190926_b()) {
            return;
        }
        this.waitForItemTicks = 0;
        int clickSlotFirst = InventoryHelper.mainInventoryToFullInventory(this.pickupSlot.get(0));
        int clickSlotSecond = InventoryHelper.mainInventoryToFullInventory(this.getFirstEmptyStack());
        InventoryHelper.swapSlot(clickSlotFirst, clickSlotSecond);
        if (this.pickupSlot.size() > 0) {
            this.pickupSlot.remove(0);
        }
    }

    public void connectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.worldAddress = event.getManager().func_74430_c().toString();
        this.isWorldLocal = event.isLocal();
        this.load();
    }

    public void disconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.save();
    }

    public void deathEvent(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player == null || Minecraft.func_71410_x().field_71439_g == null || !player.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                return;
            }
            if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                HotbarLogic.reset();
            }
        }
    }

    public void playerTick(TickEvent.PlayerTickEvent event) {
        this.reorderPickedupItem();
        this.updateIgnoredSlotTicks();
        if (this.isWorldLocal) {
            return;
        }
        this.checkPlayerDeath();
        this.checkItemPickedUp();
    }

    private void updateIgnoredSlotTicks() {
        for (Map.Entry<Integer, Integer> slot : ignoreSlots.entrySet()) {
            if (slot.getValue() == 0) {
                ignoreSlots.remove(slot.getKey());
                continue;
            }
            slot.setValue(slot.getValue() - 1);
        }
    }

    private void checkItemPickedUp() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.inventory == null || Minecraft.func_71410_x().field_71462_r instanceof GuiInventory || Minecraft.func_71410_x().field_71462_r instanceof GuiContainer || Minecraft.func_71410_x().field_71462_r instanceof GuiContainerCreative) {
            this.inventory = new ArrayList<ItemStack>((Collection<ItemStack>)player.field_71071_by.field_70462_a);
        }
        ArrayList<EntityItem> changed = new ArrayList<EntityItem>();
        ArrayList<Integer> changedSlot = new ArrayList<Integer>();
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (ignoreSlots.containsKey(i) || (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || !this.inventory.get(i).func_190926_b()) && (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || ((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77969_a(this.inventory.get(i)) && ItemStack.func_77970_a((ItemStack)((ItemStack)player.field_71071_by.field_70462_a.get(i)), (ItemStack)this.inventory.get(i)))) continue;
            ItemStack changedStack = ((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l();
            changed.add(new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70163_u, changedStack));
            changedSlot.add(i);
        }
        if (!changed.isEmpty()) {
            int slot;
            int size = changed.size();
            if (size > 1 && this.areInventoryItemsSame((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, this.inventory)) {
                return;
            }
            ItemStack[] inventoryUntouched = new ItemStack[player.field_71071_by.field_70462_a.size()];
            for (slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
                inventoryUntouched[slot] = ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77946_l();
            }
            for (int i = 0; i < size; ++i) {
                int slot2 = (Integer)changedSlot.get(0);
                if (this.inventory.get(slot2).func_190926_b()) {
                    ((ItemStack)player.field_71071_by.field_70462_a.get(slot2)).func_190920_e(0);
                } else {
                    ((ItemStack)player.field_71071_by.field_70462_a.get(slot2)).func_190920_e(((ItemStack)player.field_71071_by.field_70462_a.get(slot2)).func_190916_E() - this.inventory.get(slot2).func_190916_E());
                }
                if (((ItemStack)player.field_71071_by.field_70462_a.get(slot2)).func_190916_E() == 0) {
                    player.field_71071_by.func_70304_b(slot2);
                }
                this.pickupEvent(new EntityItemPickupEvent((EntityPlayer)player, (EntityItem)changed.get(0)));
                changed.remove(0);
                changedSlot.remove(0);
            }
            for (slot = 0; slot < inventoryUntouched.length; ++slot) {
                player.field_71071_by.field_70462_a.set(slot, (Object)inventoryUntouched[slot]);
            }
        }
        this.inventory = new ArrayList<ItemStack>((Collection<ItemStack>)player.field_71071_by.field_70462_a);
    }

    private boolean areInventoryItemsSame(NonNullList<ItemStack> inventory, List<ItemStack> inventory2) {
        for (ItemStack item : inventory) {
            boolean found = false;
            for (ItemStack item2 : inventory2) {
                if ((!item.func_190926_b() || !item2.func_190926_b()) && (item.func_190926_b() || item2.func_190926_b() || !item.func_77969_a(item2) || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)item2))) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void checkPlayerDeath() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!player.func_70089_S()) {
            for (ItemStack slot : player.field_71069_bz.func_75138_a()) {
                if (slot == null) continue;
                return;
            }
            HotbarLogic.reset();
        }
    }

    private static void addInventoryReorderDelay(int delay) {
        inventoryReorderDelayTicks += delay;
    }

    public static void ignoreSlot(int slot) {
        ignoreSlots.put(slot, 5);
    }

    static {
        inventoryReorderDelayTicks = 0;
        ignoreSlots = new ConcurrentHashMap();
    }
}

