/*
 * Decompiled with CFR 0.152.
 */
package com.rolandoislas.multihotbar;

import com.rolandoislas.multihotbar.Config;
import com.rolandoislas.multihotbar.HotBarRenderer;
import com.rolandoislas.multihotbar.HotbarLogic;
import com.rolandoislas.multihotbar.InventoryHelper;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.lwjgl.opengl.GL11;

public class EventHandlerClient {
    private HotBarRenderer hotbarRender = new HotBarRenderer();
    private HotbarLogic hotbarLogic = new HotbarLogic();
    private boolean renderPosted = true;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleHotbarRender(RenderGameOverlayEvent event) {
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) && event.isCancelable() && !HotbarLogic.showDefault) {
            event.setCanceled(true);
            this.hotbarRender.render();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void mouseEvent(MouseEvent event) {
        this.hotbarLogic.mouseEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void shiftOverlayUp(RenderGameOverlayEvent.Pre event) {
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) && !this.renderPosted) {
            GL11.glPopMatrix();
            this.renderPosted = true;
        }
        if (!HotbarLogic.showDefault && Config.numberOfHotbars > 2 && this.isElementToShift(event.type)) {
            if (!this.renderPosted) {
                GL11.glPopMatrix();
            }
            this.renderPosted = false;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-22.0f, (float)0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void shiftOverlayDown(RenderGameOverlayEvent.Post event) {
        if (!HotbarLogic.showDefault && Config.numberOfHotbars > 2 && this.isElementToShift(event.type)) {
            this.renderPosted = true;
            GL11.glPopMatrix();
        }
    }

    private boolean isElementToShift(RenderGameOverlayEvent.ElementType type) {
        return type == RenderGameOverlayEvent.ElementType.CHAT || type == RenderGameOverlayEvent.ElementType.HEALTH || type == RenderGameOverlayEvent.ElementType.AIR || type == RenderGameOverlayEvent.ElementType.ARMOR || type == RenderGameOverlayEvent.ElementType.EXPERIENCE || type == RenderGameOverlayEvent.ElementType.FOOD || type == RenderGameOverlayEvent.ElementType.HEALTHMOUNT || type == RenderGameOverlayEvent.ElementType.JUMPBAR;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("multihotbar")) {
            Config.config.save();
            Config.reload();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void keyPressed(InputEvent.KeyInputEvent event) {
        this.hotbarLogic.keyPressed(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void worldLoad(WorldEvent.Load event) {
        this.hotbarLogic.load(event.world);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void connectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.hotbarLogic.setWorldAddress(event.manager.func_74430_c().toString());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void worldUnload(WorldEvent.Unload event) {
        this.hotbarLogic.save();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void changeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.hotbarLogic.playerChangedDimension();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            HotbarLogic.reset();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void playerTick(TickEvent.PlayerTickEvent event) {
        InventoryHelper.tick();
    }
}

