/*
 * Decompiled with CFR 0.152.
 */
package com.rolandoislas.multihotbar;

import com.rolandoislas.multihotbar.Config;
import com.rolandoislas.multihotbar.HotbarLogic;
import com.rolandoislas.multihotbar.InventoryHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class HotBarRenderer
extends Gui {
    private static final int HOTBAR_WIDTH = 182;
    private static final int HOTBAR_HEIGHT = 22;
    private static final int SELECTOR_SIZE = 24;
    private final ResourceLocation WIDGETS;
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public HotBarRenderer() {
        this.WIDGETS = new ResourceLocation("minecraft", "textures/gui/widgets.png");
    }

    public void render() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        if (Config.numberOfHotbars == 1) {
            this.drawSingle(0);
        } else if (Config.numberOfHotbars == 2) {
            this.drawDouble(0);
        } else if (Config.numberOfHotbars == 3) {
            this.drawDouble(0);
            this.drawSingle(2);
        } else if (Config.numberOfHotbars == 4) {
            this.drawDouble(0);
            this.drawDouble(2);
        }
        this.drawSelection();
        this.drawItems();
    }

    private void drawItems() {
        for (int i = 0; i < Config.numberOfHotbars; ++i) {
            this.drawItems(i, HotbarLogic.hotbarOrder[i]);
        }
    }

    private void drawSelection() {
        if (InventoryHelper.waitTicks > 0) {
            return;
        }
        int slot = this.minecraft.field_71439_g.field_71071_by.field_70461_c;
        int index = HotbarLogic.hotbarIndex;
        int[] coords = this.getHotbarCoords(index);
        int x = coords[0];
        int y = coords[1];
        this.minecraft.func_110434_K().func_110577_a(this.WIDGETS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.field_73735_i += 100.0f;
        this.minecraft.field_71456_v.func_73729_b(-1 + x + 20 * slot, y - 1, 0, 22, 24, 24);
    }

    private void drawSingle(int index) {
        int[] coords = this.getHotbarCoords(index);
        this.drawHotbar(coords[0], coords[1]);
    }

    private void drawDouble(int index) {
        for (int i = index; i < index + 2; ++i) {
            int[] coords = this.getHotbarCoords(i);
            this.drawHotbar(coords[0], coords[1]);
        }
    }

    private int[] getHotbarCoords(int index) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ScaledResolution scaledResolution = new ScaledResolution(minecraft);
        int[] coords = new int[2];
        if (Config.numberOfHotbars == 1) {
            coords[0] = scaledResolution.func_78326_a() / 2 - 91;
            coords[1] = scaledResolution.func_78328_b() - 22 * (index + 1);
        } else if (Config.numberOfHotbars == 2 || Config.numberOfHotbars == 4) {
            coords[0] = scaledResolution.func_78326_a() / 2 - 182 * (index == 0 || index == 2 ? 1 : 0);
            coords[1] = scaledResolution.func_78328_b() - 22 * (index == 0 || index == 1 ? 1 : 2);
        } else if (Config.numberOfHotbars == 3) {
            coords[0] = (int)((double)(scaledResolution.func_78326_a() / 2) - 182.0 * (index == 2 ? 0.5 : (double)(index != 1 ? 1 : 0)));
            coords[1] = scaledResolution.func_78328_b() - 22 * (index == 2 ? 2 : 1);
        }
        return coords;
    }

    private int getXForSlot(int index, int slot) {
        int[] coords = this.getHotbarCoords(index);
        int x = coords[0] + 3 + 16 * slot + 4 * slot;
        return x;
    }

    private int getYForSlot(int index) {
        int[] coords = this.getHotbarCoords(index);
        int y = coords[1] + 3;
        return y;
    }

    private void drawHotbar(int x, int y) {
        this.minecraft.func_110434_K().func_110577_a(this.WIDGETS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.minecraft.field_71456_v.func_73729_b(x, y, 0, 0, 182, 22);
    }

    private void drawItems(int hotbarIndex, int slotIndex) {
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        for (int i = slotIndex * 9; i < slotIndex * 9 + 9; ++i) {
            ItemStack item = this.minecraft.field_71439_g.field_71071_by.func_70301_a(i);
            if (item == null) continue;
            int itemX = this.getXForSlot(hotbarIndex, i - slotIndex * 9);
            int itemY = this.getYForSlot(hotbarIndex);
            this.minecraft.func_175599_af().func_180450_b(item, itemX, itemY);
            this.minecraft.func_175599_af().func_180453_a(this.minecraft.field_71466_p, item, itemX, itemY, item.field_77994_a > 1 ? String.valueOf(item.field_77994_a) : "");
        }
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
    }
}

