/*
 * Decompiled with CFR 0.152.
 */
package com.rolandoislas.multihotbar;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.rolandoislas.multihotbar.Config;
import com.rolandoislas.multihotbar.InventoryHelper;
import com.rolandoislas.multihotbar.KeyBindings;
import com.rolandoislas.multihotbar.WorldJson;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;

public class HotbarLogic {
    public static int hotbarIndex = 0;
    public static int[] hotbarOrder = new int[4];
    public static boolean showDefault = false;
    private static WorldJson[] worldJsonArray;
    private World world;
    private String worldAddress;
    private World dimWorld;

    public void mouseEvent(MouseEvent event) {
        if (event.dwheel != 0) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (event.dwheel < 0) {
                if (KeyBindings.scrollModifier.func_151470_d()) {
                    this.moveSelectionToNextHotbar();
                } else if (player.field_71071_by.field_70461_c < InventoryPlayer.func_70451_h() - 1) {
                    ++player.field_71071_by.field_70461_c;
                } else {
                    player.field_71071_by.field_70461_c = 0;
                    this.moveSelectionToNextHotbar();
                }
            } else if (KeyBindings.scrollModifier.func_151470_d()) {
                this.moveSelectionToPreviousHotbar();
            } else if (player.field_71071_by.field_70461_c > 0) {
                --player.field_71071_by.field_70461_c;
            } else {
                player.field_71071_by.field_70461_c = InventoryPlayer.func_70451_h() - 1;
                this.moveSelectionToPreviousHotbar();
            }
            event.setCanceled(true);
        }
    }

    private void moveSelectionToPreviousHotbar() {
        this.moveSelection(false);
    }

    private void moveSelection(boolean forward) {
        int previousIndex = hotbarIndex;
        hotbarIndex = (hotbarIndex += forward ? 1 : -1) < 0 ? Config.numberOfHotbars - 1 : hotbarIndex;
        hotbarIndex = hotbarIndex >= Config.numberOfHotbars ? 0 : hotbarIndex;
        InventoryHelper.swapHotbars(0, hotbarOrder[hotbarIndex]);
        int orderFirst = hotbarOrder[previousIndex];
        HotbarLogic.hotbarOrder[previousIndex] = hotbarOrder[hotbarIndex];
        HotbarLogic.hotbarOrder[HotbarLogic.hotbarIndex] = orderFirst;
    }

    private void moveSelectionToNextHotbar() {
        this.moveSelection(true);
    }

    public void keyPressed(InputEvent.KeyInputEvent event) {
        int slot = KeyBindings.isHotbarKeyDown();
        int currentItem = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c;
        if (slot > -1 && currentItem == slot) {
            this.moveSelectionToNextHotbar();
        } else if (slot > -1) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c = slot;
            if (!Config.relativeHotbarKeys) {
                this.moveSelectionToFirstHotbar();
            }
        }
        if (KeyBindings.showDefaultHotbar.func_151468_f()) {
            showDefault = !showDefault;
        }
    }

    private void moveSelectionToFirstHotbar() {
        int awayFromZero = hotbarIndex;
        if (awayFromZero == 0) {
            return;
        }
        for (int i = 0; i < Config.numberOfHotbars - awayFromZero; ++i) {
            this.moveSelectionToNextHotbar();
        }
    }

    public static void reset() {
        showDefault = false;
        hotbarIndex = 0;
        for (int i = 0; i < 4; ++i) {
            HotbarLogic.hotbarOrder[i] = i;
        }
    }

    public void save() {
        if (this.world == null) {
            return;
        }
        String path = Config.config.getConfigFile().getAbsolutePath().replace("cfg", "json");
        try {
            boolean found = false;
            if (worldJsonArray != null) {
                for (WorldJson worldJson : worldJsonArray) {
                    if (!worldJson.getId().equals(this.getWorldId())) continue;
                    found = true;
                    worldJson.setIndex(hotbarIndex);
                    worldJson.setOrder(hotbarOrder);
                    break;
                }
            }
            if (!found || worldJsonArray == null) {
                worldJsonArray = worldJsonArray == null ? new WorldJson[1] : Arrays.copyOf(worldJsonArray, worldJsonArray.length + 1);
                int index = worldJsonArray.length - 1;
                HotbarLogic.worldJsonArray[index] = new WorldJson();
                worldJsonArray[index].setId(this.getWorldId());
                worldJsonArray[index].setIndex(hotbarIndex);
                worldJsonArray[index].setOrder(hotbarOrder);
            }
            Gson gson = new Gson();
            FileWriter writer = new FileWriter(path);
            String json = gson.toJson((Object)worldJsonArray);
            writer.write(json);
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dimWorld = this.world;
        this.world = null;
    }

    public void load(World world) {
        block6: {
            if (this.world != null) {
                return;
            }
            this.world = world;
            String path = Config.config.getConfigFile().getAbsolutePath().replace("cfg", "json");
            try {
                Gson gson = new Gson();
                JsonReader reader = new JsonReader((Reader)new FileReader(path));
                worldJsonArray = (WorldJson[])gson.fromJson(reader, WorldJson[].class);
                if (worldJsonArray != null) {
                    for (WorldJson worldJson : worldJsonArray) {
                        if (worldJson.getId().equals(this.getWorldId(world))) {
                            hotbarIndex = worldJson.getIndex();
                            hotbarOrder = worldJson.getOrder();
                            break block6;
                        }
                        HotbarLogic.reset();
                    }
                    break block6;
                }
                HotbarLogic.reset();
            }
            catch (FileNotFoundException ignore) {
                HotbarLogic.reset();
            }
        }
    }

    private String getWorldId() {
        return this.getWorldId(this.world);
    }

    private String getWorldId(World world) {
        String id = "";
        id = !world.field_72995_K ? id + world.func_72912_H().func_76063_b() + world.func_72912_H().func_76065_j() + world.field_72995_K + world.func_72860_G().func_75765_b().getAbsolutePath() : this.worldAddress;
        return id;
    }

    public void setWorldAddress(String worldAddress) {
        this.worldAddress = worldAddress;
    }

    public void playerChangedDimension() {
        this.load(this.dimWorld);
    }
}

