/*
 * Decompiled with CFR 0.152.
 */
package com.rolandoislas.multihotbar;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static final int MAX_HOTBARS = 4;
    public static int numberOfHotbars;
    public static Configuration config;
    public static boolean relativeHotbarKeys;
    public static boolean relativeHotbarPickups;

    public static void load() {
        boolean server;
        boolean bl = server = FMLCommonHandler.instance().getSide() == Side.SERVER;
        if (server) {
            numberOfHotbars = 4;
            return;
        }
        config.load();
        numberOfHotbars = config.getInt("Number of Hotbars", "general", 2, 2, 4, "Defines the amount of hotbars that should be displayed");
        relativeHotbarKeys = config.getBoolean("Relative Hotbar Keys", "general", false, "If set to true, pressing the hotbar keys (e.g. 1-9) will move to the slot on the currently selected hotbar instead of the first");
        relativeHotbarPickups = config.getBoolean("Relative Hotbar Pickups", "general", false, "When enabled slots are filled starting with the currently selected hotbar. If disabled slots fill starting from the first hotbar.");
        config.save();
    }

    public static void reload() {
        Config.load();
    }

    public static void setConfigFile(File configFile) {
        config = new Configuration(configFile);
    }

    public static void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("multihotbar")) {
            config.save();
            Config.reload();
        }
    }
}

