/*
 * Decompiled with CFR 0.152.
 */
package com.rolandoislas.multihotbar.event;

import com.rolandoislas.multihotbar.HotBarRenderer;
import com.rolandoislas.multihotbar.HotbarLogic;
import com.rolandoislas.multihotbar.data.Config;
import com.rolandoislas.multihotbar.util.GuiUtil;
import com.rolandoislas.multihotbar.util.InvTweaksHelper;
import com.rolandoislas.multihotbar.util.InventoryHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class EventHandlerClient {
    private HotBarRenderer hotbarRender = new HotBarRenderer();
    private HotbarLogic hotbarLogic = new HotbarLogic();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderGameOverlayEvent(RenderGameOverlayEvent event) {
        this.hotbarRender.renderOverlayEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void mouseEvent(MouseEvent event) {
        this.hotbarLogic.mouseEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void pickupEvent(EntityItemPickupEvent event) {
        this.hotbarLogic.pickupEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        this.hotbarRender.renderGameOverlayPre(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderOverlayEventPost(RenderGameOverlayEvent.Post event) {
        this.hotbarRender.renderOverlayEventPost(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        Config.configChanged(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void keyPressed(InputEvent.KeyInputEvent event) {
        this.hotbarLogic.keyPressed(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void connectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.hotbarLogic.connectedToServer(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void disconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.hotbarLogic.disconnectedFromServer(event);
        InvTweaksHelper.reset();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void deathEvent(LivingDeathEvent event) {
        this.hotbarLogic.deathEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void playerTick(TickEvent.PlayerTickEvent event) {
        InventoryHelper.tick();
        this.hotbarLogic.playerTick(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void guiEvent(GuiScreenEvent event) {
        GuiUtil.guiEvent(event);
    }
}

