/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.lib;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.thedragonteam.thedragonlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u0000J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\u001e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000J!\u0010#\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0086\u0002J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000J\u001e\u0010$\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000J\b\u0010%\u001a\u00020&H\u0016R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015\u00a8\u0006("}, d2={"Lnet/thedragonteam/thedragonlib/lib/Vec3D;", "", "()V", "entity", "Lnet/minecraft/entity/Entity;", "(Lnet/minecraft/entity/Entity;)V", "x", "", "y", "z", "(DDD)V", "vec3I", "(Lnet/thedragonteam/thedragonlib/lib/Vec3D;)V", "pos", "Lnet/minecraft/util/math/BlockPos;", "(Lnet/minecraft/util/math/BlockPos;)V", "getPos", "()Lnet/minecraft/util/math/BlockPos;", "getX", "()D", "setX", "(D)V", "getY", "setY", "getZ", "setZ", "add", "vec", "copy", "equals", "", "obj", "hashCode", "", "multiply", "set", "subtract", "toString", "", "Companion", "TheDragonLib - Kotlin-compileKotlin"})
public final class Vec3D {
    private double x;
    private double y;
    private double z;
    public static final Companion Companion = new Companion(null);

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    @NotNull
    public final Vec3D set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NotNull
    public final Vec3D set(@NotNull Vec3D vec) {
        Intrinsics.checkParameterIsNotNull((Object)vec, (String)"vec");
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }

    @NotNull
    public final Vec3D set(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        return this;
    }

    @NotNull
    public final Vec3D add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @NotNull
    public final Vec3D add(@NotNull Vec3D vec) {
        Intrinsics.checkParameterIsNotNull((Object)vec, (String)"vec");
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    @NotNull
    public final Vec3D add(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        this.x += (double)pos.func_177958_n();
        this.y += (double)pos.func_177956_o();
        this.z += (double)pos.func_177952_p();
        return this;
    }

    @NotNull
    public final Vec3D subtract(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        this.x -= (double)pos.func_177958_n();
        this.y -= (double)pos.func_177956_o();
        this.z -= (double)pos.func_177952_p();
        return this;
    }

    @NotNull
    public final Vec3D subtract(@NotNull Vec3D vec) {
        Intrinsics.checkParameterIsNotNull((Object)vec, (String)"vec");
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    @NotNull
    public final Vec3D subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    @NotNull
    public final Vec3D multiply(@NotNull Vec3D vec) {
        Intrinsics.checkParameterIsNotNull((Object)vec, (String)"vec");
        this.x *= vec.x;
        this.y *= vec.y;
        this.z *= vec.z;
        return this;
    }

    @NotNull
    public final Vec3D multiply(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    @NotNull
    public final Vec3D copy() {
        return new Vec3D(this);
    }

    @NotNull
    public final BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Vec3D: [x: %s, y: %s, z: %s]";
        Object[] objectArray = new Object[]{this.x, this.y, this.z};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public boolean equals(@Nullable Object obj) {
        Vec3D other;
        if (this == obj) {
            return true;
        }
        if (obj == null || Intrinsics.areEqual(this.getClass(), obj.getClass()) ^ true) {
            return false;
        }
        Vec3D vec3D = other = (Vec3D)obj;
        if (vec3D == null) {
            Intrinsics.throwNpe();
        }
        return this.x == vec3D.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return ((int)this.y + (int)this.z * 31) * 31 + (int)this.x;
    }

    public Vec3D() {
    }

    public Vec3D(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.x = entity.field_70165_t;
        this.y = entity.field_70163_u;
        this.z = entity.field_70161_v;
    }

    public Vec3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3D(@NotNull Vec3D vec3I) {
        Intrinsics.checkParameterIsNotNull((Object)vec3I, (String)"vec3I");
        this.x = vec3I.x;
        this.y = vec3I.y;
        this.z = vec3I.z;
    }

    public Vec3D(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lnet/thedragonteam/thedragonlib/lib/Vec3D$Companion;", "", "()V", "getDirectionVec", "Lnet/thedragonteam/thedragonlib/lib/Vec3D;", "vecFrom", "vecTo", "TheDragonLib - Kotlin-compileKotlin"})
    public static final class Companion {
        @NotNull
        public final Vec3D getDirectionVec(@NotNull Vec3D vecFrom, @NotNull Vec3D vecTo) {
            Intrinsics.checkParameterIsNotNull((Object)vecFrom, (String)"vecFrom");
            Intrinsics.checkParameterIsNotNull((Object)vecTo, (String)"vecTo");
            double distance = Utils.INSTANCE.getDistanceAtoB(vecFrom, vecTo);
            if (distance == 0.0) {
                distance = 0.1;
            }
            Vec3D offset = vecTo.copy();
            offset.subtract(vecFrom);
            return new Vec3D(offset.getX() / distance, offset.getY() / distance, offset.getZ() / distance);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

