/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.util;

import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemStackUtils {
    public static ItemStack getTICItemStack(String name, int meta) {
        return name != null ? ItemStackUtils.getItemStack(Item.func_111206_d((String)("tconstruct:" + name)), meta) : ItemStack.field_190927_a;
    }

    public static ItemStack getAPItemStack(String name, int meta) {
        return name != null ? ItemStackUtils.getItemStack(Item.func_111206_d((String)("armorplus:" + name)), meta) : ItemStack.field_190927_a;
    }

    public static ItemStack getAPItemStack(String name) {
        return name != null ? ItemStackUtils.getItemStack(Item.func_111206_d((String)("armorplus:" + name)), 0) : ItemStack.field_190927_a;
    }

    public static ItemStack getItemStack(String modid, String itemName, int meta) {
        return modid == null || itemName == null || Item.func_111206_d((String)(modid + ":" + itemName)) == null ? ItemStack.field_190927_a : ItemStackUtils.getItemStack(Item.func_111206_d((String)(modid + ":" + itemName)), meta);
    }

    public static ItemStack getItemStack(String name, int meta) {
        return name == null || Item.func_111206_d((String)name) == null ? ItemStack.field_190927_a : ItemStackUtils.getItemStack(Item.func_111206_d((String)name), meta);
    }

    public static ItemStack getItemStack(String name) {
        return name == null || Item.func_111206_d((String)name) == null ? ItemStack.field_190927_a : ItemStackUtils.getItemStack(Item.func_111206_d((String)name), 0);
    }

    public static ItemStack getItemStack(String modid, String itemName) {
        return modid == null || itemName == null || Item.func_111206_d((String)(modid + ":" + itemName)) == null ? ItemStack.field_190927_a : ItemStackUtils.getItemStack(Item.func_111206_d((String)(modid + ":" + itemName)), 0);
    }

    public static ItemStack getItemStack(Item item, int amount, int meta) {
        return new ItemStack(item, amount, meta);
    }

    public static ItemStack getItemStack(Item item, int meta) {
        return ItemStackUtils.getItemStack(item, 1, meta);
    }

    public static ItemStack getItemStack(Item item) {
        return new ItemStack(item, 1);
    }

    public static ItemStack getItemStack(Block block, int amount, int meta) {
        return new ItemStack(block, amount, meta);
    }

    public static ItemStack getItemStack(Block block, int meta) {
        return ItemStackUtils.getItemStack(block, 1, meta);
    }

    public static ItemStack getItemStack(Block block) {
        return new ItemStack(block, 1);
    }

    public static ItemStack getEmptyStack() {
        return ItemStack.field_190927_a;
    }

    public static Item getItem(ItemStack stack) {
        return !stack.func_190926_b() ? stack.func_77973_b() : Items.field_190931_a;
    }

    public static Item getItem(Block block) {
        return Item.func_150898_a((Block)block);
    }

    public static Item getItem(String modName, String itemName) {
        return modName != null ? Item.func_111206_d((String)(modName + ":" + itemName)) : Items.field_190931_a;
    }

    public static Item getItem(String name) {
        return name != null ? Item.func_111206_d((String)name) : Items.field_190931_a;
    }

    public static Item getEmptyItem() {
        return Items.field_190931_a;
    }

    public static ItemStack validateCopy(ItemStack stack) {
        return ItemStackUtils.isValid(stack) ? stack.func_77946_l() : ItemStackUtils.getNull();
    }

    public static ItemStack validateCheck(ItemStack stack) {
        return ItemStackUtils.isValid(stack) ? stack : ItemStackUtils.getNull();
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && !stack.func_190926_b();
    }

    public static ItemStack getNull() {
        return ItemStack.field_190927_a;
    }

    public static int getStackSize(ItemStack stack) {
        return !ItemStackUtils.isValid(stack) ? 0 : stack.func_190916_E();
    }

    public static ItemStack setStackSize(ItemStack stack, int size) {
        return ItemStackUtils.setStackSize(stack, size, false);
    }

    public static ItemStack setStackSize(ItemStack stack, int size, boolean containerOnEmpty) {
        if (size <= 0) {
            return ItemStackUtils.isValid(stack) && containerOnEmpty ? stack.func_77973_b().getContainerItem(stack) : ItemStackUtils.getNull();
        }
        stack.func_190920_e(size);
        return stack;
    }

    public static ItemStack addStackSize(ItemStack stack, int size) {
        return ItemStackUtils.addStackSize(stack, size, false);
    }

    public static ItemStack addStackSize(ItemStack stack, int size, boolean containerOnEmpty) {
        return ItemStackUtils.setStackSize(stack, ItemStackUtils.getStackSize(stack) + size, containerOnEmpty);
    }

    public static boolean isIInvEmpty(NonNullList<ItemStack> slots) {
        return slots.stream().noneMatch(ItemStackUtils::isValid);
    }

    public static NonNullList<ItemStack> createSlots(int size) {
        return NonNullList.func_191197_a((int)size, (Object)ItemStackUtils.getNull());
    }
}

