/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.api.crafting.workbench_new;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.thedragonteam.armorplus.api.crafting.workbench_new.IRecipe;
import net.thedragonteam.armorplus.container.inventory.InventoryCraftingNew;

public class WorkbenchNewCraftingManager {
    private static final WorkbenchNewCraftingManager INSTANCE = new WorkbenchNewCraftingManager();
    private final List<IRecipe> recipes = Lists.newArrayList();

    private WorkbenchNewCraftingManager() {
        this.recipes.sort((pCompare1, pCompare2) -> pCompare2.getRecipeSize() < pCompare1.getRecipeSize() ? -1 : (pCompare2.getRecipeSize() > pCompare1.getRecipeSize() ? 1 : 0));
    }

    public static WorkbenchNewCraftingManager getInstance() {
        return INSTANCE;
    }

    public void addRecipe(IRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void removeRecipe(IRecipe recipe) {
        this.recipes.remove(recipe);
    }

    public ItemStack findMatchingRecipe(InventoryCraftingNew craftMatrix, World worldIn) {
        return this.recipes.stream().filter(irecipe -> irecipe.matches(craftMatrix, worldIn)).findFirst().map(irecipe -> irecipe.getCraftingResult(craftMatrix)).orElse(ItemStack.field_190927_a);
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCraftingNew craftMatrix, World worldIn) {
        for (IRecipe irecipe : this.recipes) {
            if (!irecipe.matches(craftMatrix, worldIn)) continue;
            return irecipe.getRemainingItems(craftMatrix);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)craftMatrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)craftMatrix.func_70301_a(i));
        }
        return nonnulllist;
    }

    public List<IRecipe> getRecipeList() {
        return this.recipes;
    }
}

