/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.tileentity.base;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.util.APTeslaUtils;
import net.thedragonteam.armorplus.util.TeslaForgeUnitsWrapper;

public abstract class TileEntityBase
extends TileEntity {
    private Object teslaWrapper;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        IItemHandler handler = this.getItemHandler(facing);
        return handler != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        IEnergyStorage storage;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler handler = this.getItemHandler(facing);
            if (handler != null) {
                return (T)handler;
            }
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler tank = this.getFluidHandler(facing);
            if (tank != null) {
                return (T)tank;
            }
        } else if (capability == CapabilityEnergy.ENERGY) {
            IEnergyStorage storage2 = this.getEnergyStorage(facing);
            if (storage2 != null) {
                return (T)storage2;
            }
        } else if (ArmorPlus.isTeslaLoaded() && (capability == APTeslaUtils.teslaConsumer || capability == APTeslaUtils.teslaProducer || capability == APTeslaUtils.teslaHolder) && (storage = this.getEnergyStorage(facing)) != null) {
            if (this.teslaWrapper == null) {
                this.teslaWrapper = new TeslaForgeUnitsWrapper(storage);
            }
            return (T)this.teslaWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return null;
    }

    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return null;
    }

    public IItemHandler getItemHandler(EnumFacing facing) {
        return null;
    }
}

