/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.tileentity.base;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.thedragonteam.armorplus.tileentity.base.TileEntityInventoryBase;

public class TileEntityBaseBench
extends TileEntityInventoryBase {
    public int inventorySize;
    public String tileEntityName;
    public NonNullList<ItemStack> inventory;
    public String customName;

    public TileEntityBaseBench(String tileEntityName, int inventorySize) {
        super(inventorySize);
        this.inventory = NonNullList.func_191197_a((int)this.inventorySize, (Object)ItemStack.field_190927_a);
        this.tileEntityName = tileEntityName;
        this.inventorySize = inventorySize;
        this.inventory = this.getItemHandler().getItems();
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return IntStream.rangeClosed(0, this.getItemHandler().getSlots()).anyMatch(i -> this.getItemHandler().getStackInSlot(slot) != ItemStack.field_190927_a);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        return IntStream.rangeClosed(0, this.getItemHandler().getSlots()).anyMatch(i -> this.getItemHandler().getStackInSlot(slot) != ItemStack.field_190927_a);
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "container.armorplus." + this.tileEntityName;
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.equals("");
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventorySize; ++i) {
            if (this.getItemHandler().getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.getItemHandler().getStackInSlot(i).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        if (this.hasCustomName()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            this.getItemHandler().setStackInSlot(slot, new ItemStack(stackTag));
        }
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return super.func_189517_E_();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return super.func_189518_D_();
    }
}

