/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.util;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.Optional;

public class APTeslaUtils {
    @CapabilityInject(value=ITeslaConsumer.class)
    public static Capability<ITeslaConsumer> teslaConsumer;
    @CapabilityInject(value=ITeslaProducer.class)
    public static Capability<ITeslaProducer> teslaProducer;
    @CapabilityInject(value=ITeslaHolder.class)
    public static Capability<ITeslaHolder> teslaHolder;

    @Optional.Method(modid="tesla")
    public static boolean isPoweredItem(ItemStack stack) {
        return stack.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN);
    }

    @Optional.Method(modid="tesla")
    public static long getStoredPower(ItemStack stack) {
        if (APTeslaUtils.isPoweredItem(stack)) {
            BaseTeslaContainer container = APTeslaUtils.getContainer(stack);
            return APTeslaUtils.getContainer(stack).getStoredPower();
        }
        return 0L;
    }

    @Optional.Method(modid="tesla")
    public static long getMaxCapacity(ItemStack stack) {
        return APTeslaUtils.isPoweredItem(stack) ? APTeslaUtils.getContainer(stack).getCapacity() : 0L;
    }

    @Optional.Method(modid="tesla")
    public static void addPower(ItemStack stack, long amount) {
        if (APTeslaUtils.isPoweredItem(stack)) {
            APTeslaUtils.getContainer(stack).givePower(amount, false);
        }
    }

    @Optional.Method(modid="tesla")
    public static BaseTeslaContainer getContainer(ItemStack stack) {
        return APTeslaUtils.isPoweredItem(stack) ? (BaseTeslaContainer)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN) : null;
    }

    @Optional.Method(modid="tesla")
    public static void setMaxCapacity(ItemStack stack, long amount) {
        if (APTeslaUtils.isPoweredItem(stack)) {
            APTeslaUtils.getContainer(stack).setCapacity(amount);
        }
    }

    @Optional.Method(modid="tesla")
    public static void usePower(ItemStack stack, long amount) {
        if (APTeslaUtils.isPoweredItem(stack)) {
            APTeslaUtils.getContainer(stack).takePower(amount, false);
        }
    }

    @Optional.Method(modid="tesla")
    public static long getMaxInput(ItemStack stack) {
        return APTeslaUtils.isPoweredItem(stack) ? APTeslaUtils.getContainer(stack).getInputRate() : 0L;
    }

    @Optional.Method(modid="tesla")
    public static long getMaxOutput(ItemStack stack) {
        return APTeslaUtils.isPoweredItem(stack) ? APTeslaUtils.getContainer(stack).getOutputRate() : 0L;
    }

    @Optional.Method(modid="tesla")
    public static ItemStack createChargedStack(ItemStack stack) {
        if (APTeslaUtils.isPoweredItem(stack)) {
            ItemStack chargedstack = stack.func_77946_l();
            APTeslaUtils.getContainer(chargedstack).setInputRate(APTeslaUtils.getMaxCapacity(stack));
            APTeslaUtils.addPower(chargedstack, APTeslaUtils.getMaxCapacity(stack));
            APTeslaUtils.getContainer(chargedstack).setInputRate(APTeslaUtils.getMaxInput(stack));
            return chargedstack;
        }
        return ItemStack.field_190927_a;
    }

    @Optional.Method(modid="tesla")
    public static boolean isTelsaBlock(TileEntity tileEntity) {
        return tileEntity.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN);
    }

    @Optional.Method(modid="tesla")
    public static BaseTeslaContainer getContainer(TileEntity tileEntity) {
        if (APTeslaUtils.isTelsaBlock(tileEntity)) {
            BaseTeslaContainer container = (BaseTeslaContainer)tileEntity.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN);
            return container;
        }
        return null;
    }

    @Optional.Method(modid="tesla")
    public static boolean isConsumer(TileEntity tileEntity) {
        return tileEntity.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, EnumFacing.DOWN);
    }

    @Optional.Method(modid="tesla")
    public static long getMaxCapacity(TileEntity tile) {
        return APTeslaUtils.getContainer(tile).getCapacity();
    }

    @Optional.Method(modid="tesla")
    public static long getStoredPower(TileEntity tile) {
        return APTeslaUtils.getContainer(tile).getStoredPower();
    }

    @Optional.Method(modid="tesla")
    public static long getMissingPower(TileEntity tileEntity) {
        return APTeslaUtils.getMaxCapacity(tileEntity) - APTeslaUtils.getStoredPower(tileEntity);
    }

    @Optional.Method(modid="tesla")
    public static boolean canAcceptPower(TileEntity tile, long amount) {
        return APTeslaUtils.getMissingPower(tile) >= amount;
    }

    @Optional.Method(modid="tesla")
    public static void addPower(TileEntity tileEntity, long amount) {
        APTeslaUtils.getContainer(tileEntity).givePower(amount, false);
    }
}

