/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.util;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureUtils {
    public static void placeWall(World worldIn, BlockPos corner, IBlockState block, int maxPos, int maxPosY, int posIn, Direction direction) {
        switch (direction) {
            case POSITION_X: {
                for (int posY = 0; posY <= maxPosY; ++posY) {
                    int pos = 0;
                    while (pos <= maxPos) {
                        int[] stoneBrick = new int[]{pos++, posY, posIn};
                        StructureUtils.placeBlock(worldIn, corner, stoneBrick, block);
                    }
                }
                break;
            }
            case POSITION_Z: {
                for (int posY = 0; posY <= maxPosY; ++posY) {
                    int pos = 0;
                    while (pos <= maxPos) {
                        int[] stoneBrick = new int[]{posIn, posY, pos++};
                        StructureUtils.placeBlock(worldIn, corner, stoneBrick, block);
                    }
                }
                break;
            }
        }
    }

    public static void placeWall(World worldIn, BlockPos corner, IBlockState block, int maxPos, int maxPosY, int posIn) {
        int[] stoneBrick;
        int pos;
        int posY;
        for (posY = 0; posY <= maxPosY; ++posY) {
            pos = 0;
            while (pos <= maxPos) {
                stoneBrick = new int[]{pos++, posY, posIn};
                StructureUtils.placeBlock(worldIn, corner, stoneBrick, block);
            }
        }
        for (posY = 0; posY <= maxPosY; ++posY) {
            pos = 0;
            while (pos <= maxPos) {
                stoneBrick = new int[]{posIn, posY, pos++};
                StructureUtils.placeBlock(worldIn, corner, stoneBrick, block);
            }
        }
    }

    public static void placeFloor(World worldIn, BlockPos corner, IBlockState block, int maxPosX, int maxPosZ) {
        StructureUtils.placeFloor(worldIn, corner, block, 0, 0, maxPosX, maxPosZ);
    }

    public static void placeFloor(World worldIn, BlockPos corner, IBlockState block, int posX, int posZ, int maxPosX, int maxPosZ) {
        StructureUtils.placeFloor(worldIn, corner, block, posX, -1, posZ, maxPosX, maxPosZ);
    }

    public static void placeFloor(World worldIn, BlockPos corner, IBlockState block, int posX, int posY, int posZ, int maxPosX, int maxPosZ) {
        StructureUtils.placeFloor(worldIn, corner, block, posX, posY, posZ, maxPosX, maxPosZ, true);
    }

    public static void placeFloor(World worldIn, BlockPos corner, IBlockState block, int posX, int posY, int posZ, int maxPosX, int maxPosZ, boolean isPositive) {
        StructureUtils.placeFloor(worldIn, corner, block, posX, posY, posZ, maxPosX, maxPosZ, isPositive ? Direction.POSITIVE_XZ : Direction.NEGATIVE_XZ);
    }

    public static void placeFloor(World worldIn, BlockPos corner, IBlockState block, int posX, int posY, int posZ, int maxPosX, int maxPosZ, Direction direction) {
        switch (direction) {
            case POSITIVE_XZ: {
                for (int z = posZ; z <= maxPosZ; ++z) {
                    int x = posX;
                    while (x <= maxPosX) {
                        int[] stoneBrickFloor = new int[]{x++, posY, z};
                        StructureUtils.placeBlock(worldIn, corner, stoneBrickFloor, block);
                    }
                }
                break;
            }
            case NEGATIVE_XZ: {
                for (int z = posZ; z <= maxPosZ; --z) {
                    int x = posX;
                    while (x <= maxPosX) {
                        int[] stoneBrickFloor = new int[]{x--, posY, z};
                        StructureUtils.placeBlock(worldIn, corner, stoneBrickFloor, block);
                    }
                }
                break;
            }
            case POSITIVE_Z_NEGATIVE_X: {
                for (int z = posZ; z <= maxPosZ; ++z) {
                    int x = posX;
                    while (x <= maxPosX) {
                        int[] stoneBrickFloor = new int[]{x--, posY, z};
                        StructureUtils.placeBlock(worldIn, corner, stoneBrickFloor, block);
                    }
                }
                break;
            }
            case POSITIVE_X_NEGATIVE_Z: {
                for (int z = posZ; z <= maxPosZ; --z) {
                    int x = posX;
                    while (x <= maxPosX) {
                        int[] stoneBrickFloor = new int[]{x++, posY, z};
                        StructureUtils.placeBlock(worldIn, corner, stoneBrickFloor, block);
                    }
                }
                break;
            }
        }
    }

    public static void placeLayer(World world, BlockPos frontLeftCorner, int[][] blockPositions, IBlockState toPlace) {
        for (int[] coord : blockPositions) {
            StructureUtils.placeBlock(world, frontLeftCorner, coord[0], coord[1], coord[2], toPlace);
        }
    }

    public static void placeTileEntity(World world, BlockPos frontLeftCorner, int[] offsets, TileEntity toPlace) {
        StructureUtils.placeTileEntity(world, frontLeftCorner, offsets[0], offsets[1], offsets[2], toPlace);
    }

    public static void placeTileEntity(World world, BlockPos frontLeftCorner, int offsetX, int offsetY, int offsetZ, TileEntity toPlace) {
        BlockPos placePos = frontLeftCorner.func_177982_a(offsetX, offsetY, offsetZ);
        world.func_175690_a(placePos, toPlace);
    }

    public static TileEntity getTileEntity(World world, BlockPos frontLeftCorner, int[] offsets) {
        return StructureUtils.getTileEntity(world, frontLeftCorner, offsets[0], offsets[1], offsets[2]);
    }

    public static TileEntity getTileEntity(World world, BlockPos frontLeftCorner, int offsetX, int offsetY, int offsetZ) {
        BlockPos placePos = frontLeftCorner.func_177982_a(offsetX, offsetY, offsetZ);
        return world.func_175625_s(placePos);
    }

    public static void placeBlock(World world, BlockPos frontLeftCorner, int[] offsets, IBlockState toPlace) {
        StructureUtils.placeBlock(world, frontLeftCorner, offsets[0], offsets[1], offsets[2], toPlace);
    }

    public static void placeBlock(World world, BlockPos frontLeftCorner, int offsetX, int offsetY, int offsetZ, IBlockState toPlace) {
        BlockPos placePos = frontLeftCorner.func_177982_a(offsetX, offsetY, offsetZ);
        world.func_180501_a(placePos, toPlace, 2);
    }

    public static boolean canSpawnHere(World world, BlockPos posAboveGround) {
        boolean corner1Air = StructureUtils.canReplace(world, posAboveGround);
        boolean corner2Air = StructureUtils.canReplace(world, posAboveGround.func_177982_a(4, 0, 0));
        boolean corner4Air = StructureUtils.canReplace(world, posAboveGround.func_177982_a(0, 0, 4));
        boolean corner3Air = StructureUtils.canReplace(world, posAboveGround.func_177982_a(4, 0, 4));
        return posAboveGround.func_177956_o() > 20 && corner1Air && corner2Air && corner3Air && corner4Air;
    }

    public static boolean canReplace(World world, BlockPos pos) {
        Block at = world.func_180495_p(pos).func_177230_c();
        Material material = at.func_149688_o(at.func_176223_P());
        return material.func_76222_j() || material == Material.field_151575_d || material == Material.field_151584_j;
    }

    public static enum Direction {
        POSITIVE_XZ,
        NEGATIVE_XZ,
        POSITIVE_X_NEGATIVE_Z,
        POSITIVE_Z_NEGATIVE_X,
        POSITION_X,
        POSITION_Z;

    }
}

