/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.worldgen.nbt;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.thedragonteam.armorplus.APConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/thedragonteam/armorplus/worldgen/nbt/StructureGenNBT;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "()V", "TOWER", "Lnet/minecraft/util/ResourceLocation;", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/chunk/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "generateTower", "Lnet/minecraft/world/WorldServer;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getGroundFromAbove", "x", "z", "ArmorPlus - Kotlin-compileKotlin"})
public final class StructureGenNBT
implements IWorldGenerator {
    private final ResourceLocation TOWER = new ResourceLocation("armorplus", "tower");

    public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkParameterIsNotNull((Object)chunkProvider, (String)"chunkProvider");
        int posX = chunkX * 16 + random.nextInt(16);
        int posZ = chunkZ * 16 + random.nextInt(16);
        BlockPos posXZ = new BlockPos(posX, 1, posZ);
        if (!(world instanceof WorldServer)) {
            return;
        }
        int posY = this.getGroundFromAbove(world, posX, posZ);
        BlockPos basePos = new BlockPos(posX, posY, posZ);
        this.generateTower((WorldServer)world, random, basePos);
    }

    public final void generateTower(@NotNull WorldServer world, @NotNull Random random, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (APConfig.enableTowerGen && random.nextInt(APConfig.towerGenSpawnNeedOfChance) < APConfig.towerGenSpawnChance) {
            PlacementSettings settings = new PlacementSettings();
            settings.func_186220_a(Rotation.NONE);
            MinecraftServer server = world.func_73046_m();
            Template template = world.func_72860_G().func_186340_h().func_186237_a(server, this.TOWER);
            template.func_186253_b((World)world, pos, settings);
        }
    }

    public final int getGroundFromAbove(@NotNull World world, int x, int z) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150346_d || blockAt == Blocks.field_150349_c || blockAt != Blocks.field_150350_a;
        }
        return y;
    }
}

