/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.armors.base.BaseArmor;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.registry.ModPotions;
import net.thedragonteam.armorplus.util.ItemStackUtils;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.ToolTipUtils;

public enum APArmorMaterial implements IStringSerializable
{
    COAL(BaseArmor.coalArmor, "coal", ItemStackUtils.getItemStack(Items.field_151044_h).func_77973_b(), ItemStackUtils.getItemStack(Blocks.field_150402_ci).func_77973_b(), TextFormatting.func_96300_b((String)APConfig.coalArmorItemNameColor), APConfig.enableFullCoalArmorEffect, APConfig.coalArmorAddPotionEffect, APConfig.coalArmorEffectLevel, new boolean[]{APConfig.enableCoalBEffect, APConfig.enableCoalLEffect, APConfig.enableCoalCEffect, APConfig.enableCoalHEffect}, "empty"),
    LAPIS(BaseArmor.lapisArmor, "lapis", ItemStackUtils.getItemStack(Items.field_151100_aR, 4), ItemStackUtils.getItemStack(Blocks.field_150368_y), TextFormatting.func_96300_b((String)APConfig.lapisArmorItemNameColor), APConfig.enableFullLapisArmorEffect, APConfig.lapisArmorAddPotionEffect, APConfig.lapisArmorEffectLevel, new boolean[]{APConfig.enableLapisBEffect, APConfig.enableLapisLEffect, APConfig.enableLapisCEffect, APConfig.enableLapisHEffect}, "empty"),
    REDSTONE(BaseArmor.redstoneArmor, "redstone", ItemStackUtils.getItemStack(Items.field_151137_ax).func_77973_b(), ItemStackUtils.getItemStack(Blocks.field_150451_bX).func_77973_b(), TextFormatting.func_96300_b((String)APConfig.redstoneArmorItemNameColor), APConfig.enableFullRedstoneArmorEffect, APConfig.redstoneArmorAddPotionEffect, APConfig.redstoneArmorEffectLevel, new boolean[]{APConfig.enableRedstoneBEffect, APConfig.enableRedstoneLEffect, APConfig.enableRedstoneCEffect, APConfig.enableRedstoneHEffect}, "empty"),
    EMERALD(BaseArmor.emeraldArmor, "emerald", ItemStackUtils.getItemStack(Items.field_151166_bC).func_77973_b(), ItemStackUtils.getItemStack(Blocks.field_150475_bE).func_77973_b(), TextFormatting.func_96300_b((String)APConfig.emeraldArmorItemNameColor), APConfig.enableFullEmeraldArmorEffect, APConfig.emeraldArmorAddPotionEffect, APConfig.emeraldArmorEffectLevel, new boolean[]{APConfig.enableEmeraldBEffect, APConfig.enableEmeraldLEffect, APConfig.enableEmeraldCEffect, APConfig.enableEmeraldHEffect}, "empty"),
    OBSIDIAN(BaseArmor.obsidianArmor, "obsidian", ItemStackUtils.getItemStack(Blocks.field_150343_Z).func_77973_b(), ItemStackUtils.getItemStack(ModBlocks.compressedObsidian).func_77973_b(), TextFormatting.func_96300_b((String)APConfig.obsidianArmorItemNameColor), APConfig.enableFullObsidianArmorEffect, APConfig.obsidianArmorAddPotionEffect, APConfig.obsidianArmorEffectLevel, new boolean[]{APConfig.enableObsidianBEffect, APConfig.enableObsidianLEffect, APConfig.enableObsidianCEffect, APConfig.enableObsidianHEffect}, "empty"),
    LAVA(BaseArmor.lavaArmor, "lava", ItemStackUtils.getItemStack(ModItems.lavaCrystal), ItemStackUtils.getItemStack(ModItems.lavaCrystal, 1), TextFormatting.func_96300_b((String)APConfig.lavaArmorItemNameColor), APConfig.enableFullLavaArmorEffect, APConfig.lavaArmorAddPotionEffect, APConfig.lavaArmorEffectLevel, new boolean[]{APConfig.enableLavaBEffect, APConfig.enableLavaLEffect, APConfig.enableLavaCEffect, APConfig.enableLavaHEffect}, "empty"){

        @Override
        public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
            if (!APConfig.enableFullLavaArmorEffect) {
                entity.func_70066_B();
                entity.func_110149_m(entity.func_180799_ab() ? 4.0f : 0.0f);
            }
            if (entity.func_70090_H() && !APConfig.enableFullLavaArmorEffect && entity.func_70660_b(MobEffects.field_76427_o) == null) {
                PotionUtils.addPotion((EntityLivingBase)entity, MobEffects.field_76421_d, 1, PotionUtils.PotionType.BAD);
                itemStack.func_77972_a(1, (EntityLivingBase)entity);
                entity.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
    }
    ,
    GUARDIAN(BaseArmor.guardianArmor, "guardian", ItemStackUtils.getItemStack(ModItems.guardianScale), TextFormatting.func_96300_b((String)APConfig.guardianArmorItemNameColor), true, APConfig.guardianArmorAddPotionEffect, APConfig.guardianArmorEffectLevel, new boolean[4], "empty"),
    SUPER_STAR(BaseArmor.superStarArmor, "super_star", ItemStackUtils.getItemStack(ModItems.witherBone), TextFormatting.func_96300_b((String)APConfig.superStarArmorItemNameColor), APConfig.enableFullSuperStarArmorEffect, APConfig.superStarArmorAddPotionEffect, APConfig.superStarArmorEffectLevel, new boolean[]{APConfig.enableSuperStarBEffect, APConfig.enableSuperStarLEffect, APConfig.enableSuperStarCEffect, APConfig.enableSuperStarHEffect}, APConfig.superStarArmorRemovePotionEffect),
    ENDER_DRAGON(BaseArmor.enderDragonArmor, "ender_dragon", ItemStackUtils.getItemStack(ModItems.enderDragonScale), TextFormatting.func_96300_b((String)APConfig.enderDragonArmorItemNameColor), true, "empty", 0, new boolean[4], APConfig.enderDragonArmorRemovePotionEffect){

        @Override
        public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
            ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
            if (APConfig.enableFlightAbility) {
                if (head == null || chest == null || legs == null || feet == null) {
                    return;
                }
                if (head.func_77973_b() == ModItems.enderDragonHelmet && chest.func_77973_b() == ModItems.enderDragonChestplate && legs.func_77973_b() == ModItems.enderDragonLeggings && feet.func_77973_b() == ModItems.enderDragonBoots || entity.field_71075_bZ.field_75098_d || entity.func_175149_v()) {
                    entity.field_71075_bZ.field_75101_c = true;
                } else {
                    entity.field_71075_bZ.field_75100_b = false;
                    entity.field_71075_bZ.field_75101_c = false;
                }
            }
            if (PotionUtils.getPotion(this.getRemovePotionEffect()) != null && PotionUtils.getPotion(this.getRemovePotionEffect()) != ModPotions.EMPTY) {
                PotionUtils.removePotion((EntityLivingBase)entity, PotionUtils.getPotion(this.getRemovePotionEffect()));
            }
        }

        @Override
        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
            KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
            if (ToolTipUtils.isKeyDown()) {
                ToolTipUtils.addToolTipFull(tooltip, "Flight");
            } else {
                ToolTipUtils.showInfo(tooltip, keyBindSneak, this.getFormatting());
            }
        }
    }
    ,
    ARDITE(BaseArmor.arditeArmor, "ardite", ItemStackUtils.getTICItemStack("ingots", 1), TextFormatting.func_96300_b((String)APConfig.arditeArmorItemNameColor), true, APConfig.arditeArmorAddPotionEffect, APConfig.arditeArmorEffectLevel, new boolean[4], "empty"),
    COBALT(BaseArmor.cobaltArmor, "cobalt", ItemStackUtils.getTICItemStack("ingots", 0), TextFormatting.func_96300_b((String)APConfig.cobaltArmorItemNameColor), true, APConfig.cobaltArmorAddPotionEffect, APConfig.cobaltArmorEffectLevel, new boolean[4], "empty"),
    MANYULLYN(BaseArmor.manyullynArmor, "manyullyn", ItemStackUtils.getTICItemStack("ingots", 2), TextFormatting.func_96300_b((String)APConfig.manyullynArmorItemNameColor), true, APConfig.manyullynArmorAddPotionEffect, APConfig.manyullynArmorEffectLevel, new boolean[4], "empty"),
    KNIGHT_SLIME(BaseArmor.knightSlimeArmor, "knight_slime", ItemStackUtils.getTICItemStack("ingots", 3), TextFormatting.func_96300_b((String)APConfig.knightSlimeArmorItemNameColor), true, APConfig.knightSlimeArmorAddPotionEffect, APConfig.knightSlimeArmorEffectLevel, new boolean[4], "empty"),
    PIG_IRON(BaseArmor.pigIronArmor, "pig_iron", ItemStackUtils.getTICItemStack("ingots", 4), TextFormatting.func_96300_b((String)APConfig.pigIronArmorItemNameColor), true, APConfig.pigIronArmorAddPotionEffect, APConfig.pigIronArmorEffectLevel, new boolean[4], "empty"){

        @Override
        public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
            ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
            if (head == null || chest == null || legs == null || feet == null) {
                return;
            }
            if (APConfig.enablePigIronArmorEffect && head.func_77973_b() == ModItems.pigIronHelmet && chest.func_77973_b() == ModItems.pigIronChestplate && legs.func_77973_b() == ModItems.pigIronLeggings && feet.func_77973_b() == ModItems.pigIronBoots && entity.func_71024_bL().func_75121_c()) {
                PotionUtils.addPotion((EntityLivingBase)entity, this.getAddPotionEffect(), this.getAddPotionEffectAmplifier(), PotionUtils.PotionType.GOOD);
                head.func_77972_a(1, (EntityLivingBase)entity);
                chest.func_77972_a(1, (EntityLivingBase)entity);
                legs.func_77972_a(1, (EntityLivingBase)entity);
                feet.func_77972_a(1, (EntityLivingBase)entity);
            }
        }
    }
    ,
    SLIME(BaseArmor.slimeArmor, "slime", ItemStackUtils.getItemStack(Items.field_151123_aH), ItemStackUtils.getItemStack(Blocks.field_180399_cE), TextFormatting.func_96300_b((String)APConfig.slimeArmorItemNameColor), true, APConfig.slimeArmorAddPotionEffect, APConfig.slimeArmorEffectLevel, new boolean[4], "empty"),
    CHICKEN(BaseArmor.chickenArmor, "chicken", Items.field_151008_G, TextFormatting.func_96300_b((String)APConfig.chickenArmorItemNameColor), true, APConfig.chickenArmorAddPotionEffect, APConfig.chickenArmorEffectLevel, new boolean[4], "empty");

    private final ItemArmor.ArmorMaterial armorMaterial;
    private final String name;
    private final Item itemEasy;
    private final Item itemExpert;
    private final TextFormatting formatting;
    private final boolean enableFullArmorEffect;
    private final String addPotionEffect;
    private final int addPotionEffectAmplifier;
    private final String removePotionEffect;
    private boolean[] areEffectsEnabled;

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, Item repairEasyIn, Item repairExpertIn, TextFormatting textFormattingIn, boolean enableFullArmorEffectIn, String addPotionEffectIn, int addPotionEffectInAmplifierIn, boolean[] areEffectsEnabledIn, String removePotionEffectIn) {
        this.armorMaterial = armorMaterialIn;
        this.name = nameIn;
        this.itemEasy = repairEasyIn;
        this.itemExpert = repairExpertIn;
        this.formatting = textFormattingIn;
        this.enableFullArmorEffect = enableFullArmorEffectIn;
        this.addPotionEffect = addPotionEffectIn;
        this.addPotionEffectAmplifier = addPotionEffectInAmplifierIn;
        this.areEffectsEnabled = areEffectsEnabledIn;
        this.removePotionEffect = removePotionEffectIn;
    }

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, ItemStack stackEasy, ItemStack stackExpert, TextFormatting textFormattingIn, boolean enableFullArmorEffectIn, String addPotionEffectIn, int addPotionEffectInAmplifierIn, boolean[] areEffectsEnabledIn, String removePotionEffectIn) {
        this(armorMaterialIn, nameIn, stackEasy.func_77973_b(), stackExpert.func_77973_b(), textFormattingIn, enableFullArmorEffectIn, addPotionEffectIn, addPotionEffectInAmplifierIn, areEffectsEnabledIn, removePotionEffectIn);
    }

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, ItemStack both, TextFormatting textFormattingIn, boolean enableFullArmorEffectIn, String addPotionEffectIn, int addPotionEffectInAmplifierIn, boolean[] areEffectsEnabledIn, String removePotionEffectIn) {
        this(armorMaterialIn, nameIn, both.func_77973_b(), both.func_77973_b(), textFormattingIn, enableFullArmorEffectIn, addPotionEffectIn, addPotionEffectInAmplifierIn, areEffectsEnabledIn, removePotionEffectIn);
    }

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, Item both, TextFormatting textFormattingIn, boolean enableFullArmorEffectIn, String addPotionEffectIn, int addPotionEffectInAmplifierIn, boolean[] areEffectsEnabledIn, String removePotionEffectIn) {
        this(armorMaterialIn, nameIn, both, both, textFormattingIn, enableFullArmorEffectIn, addPotionEffectIn, addPotionEffectInAmplifierIn, areEffectsEnabledIn, removePotionEffectIn);
    }

    public ItemArmor.ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public Item getItemEasy() {
        return this.itemEasy;
    }

    public Item getItemExpert() {
        return this.itemExpert;
    }

    public TextFormatting getFormatting() {
        return this.formatting;
    }

    public boolean enableFullArmorEffect() {
        return this.enableFullArmorEffect;
    }

    public String getAddPotionEffect() {
        return this.addPotionEffect;
    }

    public int getAddPotionEffectAmplifier() {
        return this.addPotionEffectAmplifier;
    }

    public boolean[] getAreEffectsEnabled() {
        return this.areEffectsEnabled;
    }

    public String getRemovePotionEffect() {
        return this.removePotionEffect;
    }

    public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (ToolTipUtils.isKeyDown()) {
            if (!this.enableFullArmorEffect()) {
                ToolTipUtils.addToolTipPiece(tooltip, PotionUtils.localizePotion(this.getAddPotionEffect()), this.getAddPotionEffectAmplifier());
            } else {
                ToolTipUtils.addToolTipFull(tooltip, PotionUtils.localizePotion(this.getAddPotionEffect()), this.getAddPotionEffectAmplifier());
            }
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, this.getFormatting());
        }
    }
}

