/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors.base;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.armors.APArmorMaterial;
import net.thedragonteam.armorplus.registry.ModPotions;
import net.thedragonteam.armorplus.util.ArmorPlusItemUtils;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.Utils;

public class BaseArmor
extends ItemArmor {
    public static ItemArmor.ArmorMaterial coalArmor = EnumHelper.addArmorMaterial((String)"coal", (String)ArmorPlus.getArmorPlusLocation("coal_armor"), (int)7, (int[])APConfig.coalArmorProtectionPoints, (int)8, (SoundEvent)SoundEvents.field_187728_s, (float)((float)APConfig.coalArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial emeraldArmor = EnumHelper.addArmorMaterial((String)"emerald", (String)ArmorPlus.getArmorPlusLocation("emerald_armor"), (int)35, (int[])APConfig.emeraldArmorProtectionPoints, (int)20, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.emeraldArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial lapisArmor = EnumHelper.addArmorMaterial((String)"lapis", (String)ArmorPlus.getArmorPlusLocation("lapis_armor"), (int)11, (int[])APConfig.lapisArmorProtectionPoints, (int)25, (SoundEvent)SoundEvents.field_187722_q, (float)((float)APConfig.lapisArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial lavaArmor = EnumHelper.addArmorMaterial((String)"lava", (String)ArmorPlus.getArmorPlusLocation("lava_armor"), (int)45, (int[])APConfig.lavaArmorProtectionPoints, (int)28, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.lavaArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial obsidianArmor = EnumHelper.addArmorMaterial((String)"obsidian", (String)ArmorPlus.getArmorPlusLocation("obsidian_armor"), (int)40, (int[])APConfig.obsidianArmorProtectionPoints, (int)25, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.obsidianArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial redstoneArmor = EnumHelper.addArmorMaterial((String)"redstone", (String)ArmorPlus.getArmorPlusLocation("redstone_armor"), (int)11, (int[])APConfig.redstoneArmorProtectionPoints, (int)25, (SoundEvent)SoundEvents.field_187722_q, (float)((float)APConfig.redstoneArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial chickenArmor = EnumHelper.addArmorMaterial((String)"chicken", (String)ArmorPlus.getArmorPlusLocation("chicken_armor"), (int)3, (int[])APConfig.chickenArmorProtectionPoints, (int)10, (SoundEvent)SoundEvents.field_187728_s, (float)((float)APConfig.chickenArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial slimeArmor = EnumHelper.addArmorMaterial((String)"slime", (String)ArmorPlus.getArmorPlusLocation("slime_armor"), (int)3, (int[])APConfig.slimeArmorProtectionPoints, (int)10, (SoundEvent)SoundEvents.field_187728_s, (float)((float)APConfig.slimeArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial enderDragonArmor = EnumHelper.addArmorMaterial((String)"enderDragon", (String)ArmorPlus.getArmorPlusLocation("ender_dragon_armor"), (int)60, (int[])APConfig.enderDragonArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.enderDragonArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial guardianArmor = EnumHelper.addArmorMaterial((String)"guardian", (String)ArmorPlus.getArmorPlusLocation("guardian_armor"), (int)50, (int[])APConfig.guardianArmorProtectionPoints, (int)28, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.guardianArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial superStarArmor = EnumHelper.addArmorMaterial((String)"superStar", (String)ArmorPlus.getArmorPlusLocation("super_star_armor"), (int)50, (int[])APConfig.superStarArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.superStarArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial arditeArmor = EnumHelper.addArmorMaterial((String)"ardite", (String)ArmorPlus.getArmorPlusLocation("ardite_armor"), (int)55, (int[])APConfig.arditeArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.arditeArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial cobaltArmor = EnumHelper.addArmorMaterial((String)"cobalt", (String)ArmorPlus.getArmorPlusLocation("cobalt_armor"), (int)44, (int[])APConfig.cobaltArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.cobaltArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial knightSlimeArmor = EnumHelper.addArmorMaterial((String)"knightSlime", (String)ArmorPlus.getArmorPlusLocation("knight_slime_armor"), (int)33, (int[])APConfig.knightSlimeArmorProtectionPoints, (int)10, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.knightSlimeArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial manyullynArmor = EnumHelper.addArmorMaterial((String)"manyullyn", (String)ArmorPlus.getArmorPlusLocation("manyullyn_armor"), (int)66, (int[])APConfig.manyullynArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.manyullynArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial pigIronArmor = EnumHelper.addArmorMaterial((String)"pigIron", (String)ArmorPlus.getArmorPlusLocation("pig_iron_armor"), (int)33, (int[])APConfig.pigIronArmorProtectionPoints, (int)10, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.pigIronArmorToughnessPoints));
    public EnumRarity formattingName;
    public Item itemEasy;
    public Item itemExpert;
    public TextFormatting formatting;
    private APArmorMaterial material;
    private EntityEquipmentSlot armorSlot;

    public BaseArmor(APArmorMaterial armorMaterial, EntityEquipmentSlot slot) {
        super(armorMaterial.getArmorMaterial(), 0, slot);
        this.itemEasy = armorMaterial.getItemEasy();
        this.itemExpert = armorMaterial.getItemExpert();
        this.formatting = armorMaterial.getFormatting();
        this.material = armorMaterial;
        this.armorSlot = slot;
        this.func_77625_d(1);
        switch (slot) {
            case FEET: {
                String boots = armorMaterial.func_176610_l() + "_boots";
                this.setRegistryName(boots);
                this.func_77655_b(Utils.setName(boots));
                break;
            }
            case LEGS: {
                String leggings = armorMaterial.func_176610_l() + "_leggings";
                this.setRegistryName(leggings);
                this.func_77655_b(Utils.setName(leggings));
                break;
            }
            case CHEST: {
                String chestplate = armorMaterial.func_176610_l() + "_chestplate";
                this.setRegistryName(chestplate);
                this.func_77655_b(Utils.setName(chestplate));
                break;
            }
            case HEAD: {
                String helmet = armorMaterial.func_176610_l() + "_helmet";
                this.setRegistryName(helmet);
                this.func_77655_b(Utils.setName(helmet));
            }
        }
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77637_a(ArmorPlus.tabArmorplus);
        this.formattingName = EnumHelper.addRarity((String)"ARMOR_COLOR", (TextFormatting)this.formatting, (String)"Armor Color");
    }

    public void addAbilities(EntityPlayer entity, boolean isEnabled, boolean isFullArmorSet, Potion addPotion, int potionAmplifier, Potion removePotion) {
        if (isFullArmorSet) {
            return;
        }
        if (isEnabled) {
            if (entity.func_70660_b(addPotion) == null || addPotion == MobEffects.field_76439_r) {
                PotionUtils.addPotion((EntityLivingBase)entity, addPotion, potionAmplifier, PotionUtils.PotionType.GOOD);
            }
            if (removePotion != null && removePotion != ModPotions.EMPTY) {
                PotionUtils.removePotion((EntityLivingBase)entity, removePotion);
            }
        }
    }

    public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
        this.material.onArmorTick(world, entity, itemStack);
        this.addEffects(entity);
    }

    private void addEffects(EntityPlayer entity) {
        switch (this.armorSlot) {
            case FEET: {
                this.addAbilities(entity, this.material.getAreEffectsEnabled()[0], this.material.enableFullArmorEffect(), PotionUtils.getPotion(this.material.getAddPotionEffect()), this.material.getAddPotionEffectAmplifier(), PotionUtils.getPotion(this.material.getRemovePotionEffect()));
                break;
            }
            case LEGS: {
                this.addAbilities(entity, this.material.getAreEffectsEnabled()[1], this.material.enableFullArmorEffect(), PotionUtils.getPotion(this.material.getAddPotionEffect()), this.material.getAddPotionEffectAmplifier(), PotionUtils.getPotion(this.material.getRemovePotionEffect()));
                break;
            }
            case CHEST: {
                this.addAbilities(entity, this.material.getAreEffectsEnabled()[2], this.material.enableFullArmorEffect(), PotionUtils.getPotion(this.material.getAddPotionEffect()), this.material.getAddPotionEffectAmplifier(), PotionUtils.getPotion(this.material.getRemovePotionEffect()));
                break;
            }
            case HEAD: {
                this.addAbilities(entity, this.material.getAreEffectsEnabled()[3], this.material.enableFullArmorEffect(), PotionUtils.getPotion(this.material.getAddPotionEffect()), this.material.getAddPotionEffectAmplifier(), PotionUtils.getPotion(this.material.getRemovePotionEffect()));
            }
        }
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return this.formattingName;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(repair, this.itemEasy, this.itemExpert);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.material.addInformation(stack, playerIn, tooltip, advanced);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

