/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.compat.tinkers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.tools.TinkerTools;

public class ModFireStorm
extends ModifierTrait {
    public ModFireStorm() {
        super("firestorm", 0xEA0000);
        this.addAspects(new ModifierAspect[]{new ModifierAspect.LevelAspect((IModifier)this, 10)});
    }

    public boolean hasTexturePerMaterial() {
        return true;
    }

    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
        this.dealFireDamage(tool, player, target);
    }

    protected void dealFireDamage(ItemStack tool, EntityLivingBase attacker, EntityLivingBase target) {
        NBTTagCompound tag = TinkerUtil.getModifierTag((ItemStack)tool, (String)this.identifier);
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger((NBTTagCompound)tag);
        int duration = this.getFireDuration(data);
        target.func_70015_d(duration);
        float fireDamage = this.getFireDamage(data);
        if (ModFireStorm.attackEntitySecondary((DamageSource)new EntityDamageSource("fire", (Entity)attacker).func_76361_j(), (float)fireDamage, (Entity)target, (boolean)false, (boolean)true)) {
            int count = Math.round(fireDamage);
            TinkerTools.proxy.spawnEffectParticle(ParticleEffect.Type.HEART_FIRE, (Entity)target, count);
        }
    }

    private float getFireDamage(ModifierNBT.IntegerNBT data) {
        return (float)data.current / 15.0f;
    }

    private int getFireDuration(ModifierNBT.IntegerNBT data) {
        return 1 + data.current / 4;
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger((NBTTagCompound)modifierTag);
        int duration = this.getFireDuration(data);
        float dmg = this.getFireDamage(data);
        return ImmutableList.of((Object)Util.translateFormatted((String)loc, (Object[])new Object[]{Util.df.format(dmg)}), (Object)Util.translateFormatted((String)(loc + 2), (Object[])new Object[]{Util.df.format(duration)}));
    }
}

