/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.compat.tinkers;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.compat.tinkers.TiCTraits;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.TinkerTraits;

public final class TiCMaterials {
    public static final List<Material> materials = Lists.newArrayList();
    public static final Material lavacrystal = TiCMaterials.mat("lava_crystal", 11742464);
    public static final Material compressed_obsidian = TiCMaterials.mat("compressed_obsidian", 21888);

    private static Material mat(String name, int color) {
        Material mat = new Material(name, color);
        materials.add(mat);
        return mat;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerMaterialRendering() {
        lavacrystal.setRenderInfo(11742464).setTextureSuffix("contrast");
        lavacrystal.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.Default(11742464));
        lavacrystal.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.BlockTexture("armorplus:blocks/block_lava_crystal"));
        compressed_obsidian.setRenderInfo(21888).setTextureSuffix("contrast");
        compressed_obsidian.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.Default(21888));
        compressed_obsidian.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.BlockTexture("armorplus:blocks/compressed_obsidian"));
    }

    @Subscribe
    public void setupMaterials() {
        lavacrystal.setCraftable(true);
        lavacrystal.setCastable(true);
        lavacrystal.addItem("gemChargedLavaCrystal", 1, 144);
        lavacrystal.addItem(new ItemStack((Item)ModItems.lavaCrystal, 1, 1), 1, 144);
        lavacrystal.addItem(new ItemStack((Item)ModItems.lavaCrystal, 1), 1, 72);
        lavacrystal.addTrait((ITrait)TiCTraits.lavacrystalic, "head");
        lavacrystal.addTrait((ITrait)TinkerTraits.flammable);
        lavacrystal.addTrait((ITrait)TinkerTraits.autosmelt, "handle");
        lavacrystal.setRepresentativeItem(new ItemStack((Item)ModItems.lavaCrystal, 1, 1));
        compressed_obsidian.setCraftable(true);
        compressed_obsidian.addTrait((ITrait)TinkerTraits.duritos);
        compressed_obsidian.addItem(new ItemStack((Block)ModBlocks.compressedObsidian, 1), 1, 144);
        compressed_obsidian.setRepresentativeItem(new ItemStack((Block)ModBlocks.compressedObsidian, 1));
        this.registerToolMaterialStats();
    }

    public void registerToolMaterialStats() {
        TinkerRegistry.addMaterialStats((Material)lavacrystal, (IMaterialStats)new HeadMaterialStats(110, 9.0f, 4.2f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, 100), new ExtraMaterialStats(100)});
        TinkerRegistry.addMaterialStats((Material)compressed_obsidian, (IMaterialStats)new HeadMaterialStats(139, 7.07f, 4.2f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 20), new ExtraMaterialStats(90)});
    }

    @Subscribe
    public void postInit() {
        if (TinkerTools.shard == null) {
            return;
        }
        for (Material material : TinkerRegistry.getAllMaterials()) {
            ItemStack shard = TinkerTools.shard.getItemstackWithMaterial(material);
            material.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(72, new ItemStack[]{shard}));
            if (material.getShard() == null) continue;
            material.setShard(shard);
        }
    }
}

