/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.base.energy.tesla;

import java.util.List;
import java.util.Set;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.base.BaseARPTeslaContainerProvider;
import net.thedragonteam.armorplus.items.base.BaseShovel;
import net.thedragonteam.armorplus.util.APTeslaUtils;
import net.thedragonteam.thedragonlib.util.TextHelper;

public class BaseTeslaShovel
extends BaseShovel {
    private int maxCapacity;
    private int output;
    private int input;

    public BaseTeslaShovel(Item.ToolMaterial material, String name, Set<Block> effectiveOn, int maxCapacity, int input, int output) {
        super(material, name);
        this.func_77637_a(ArmorPlus.tabArmorplusTesla);
        this.func_77625_d(1);
        this.maxCapacity = maxCapacity;
        this.output = output;
        this.input = input;
    }

    public BaseTeslaShovel(Item.ToolMaterial material, String name, int maxCapacity, int input, int output) {
        this(material, name, null, maxCapacity, input, output);
        this.func_77637_a(ArmorPlus.tabArmorplusTesla);
        this.func_77625_d(1);
        this.maxCapacity = maxCapacity;
        this.output = output;
        this.input = input;
    }

    @Optional.Method(modid="tesla")
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack powered = APTeslaUtils.createChargedStack(new ItemStack(itemIn));
        ItemStack unpowered = new ItemStack(itemIn);
        subItems.add(powered);
        subItems.add(unpowered);
    }

    public String func_77653_i(ItemStack stack) {
        return (TextFormatting.func_96300_b((String)APConfig.teslaWeaponItemNameColor) + TextHelper.localize((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    public boolean isRepairable() {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 30;
    }

    @Optional.Method(modid="tesla")
    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)APTeslaUtils.getStoredPower(stack) / (double)APTeslaUtils.getMaxCapacity(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="tesla")
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new BaseARPTeslaContainerProvider(new BaseTeslaContainer(), this.maxCapacity, this.output, this.input);
    }
}

