/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.energy.rf;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.items.base.energy.rf.BaseRF;

public class ItemEnergyStorage
extends BaseRF {
    public ItemEnergyStorage() {
        super("energy_storage", Integer.MAX_VALUE);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack powered = new ItemStack(itemIn, 1, 1);
        ItemStack unpowered = new ItemStack(itemIn);
        this.poweredItem(powered);
        subItems.add(powered);
        this.createPoweredStack(powered, false);
        subItems.add(unpowered);
    }

    public CreativeTabs func_77640_w() {
        return null;
    }

    private int poweredItem(ItemStack itemStack) {
        return this.receiveEnergy(itemStack, this.getMaxEnergyStored(itemStack), false);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77952_i() == 1) {
            this.createPoweredStack(stack, false);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.createTooltip(stack, tooltip);
    }

    private int createPoweredStack(ItemStack container, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", Integer.MAX_VALUE);
        }
        return Integer.MAX_VALUE;
    }

    private void createTooltip(ItemStack stack, List<String> tooltip) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"", (Object[])new Object[0]) + this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack) + I18n.func_135052_a((String)" RF", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.rf.showinfo", (Object[])new Object[]{TextFormatting.DARK_RED, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }
}

