/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.energy.rf;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.items.base.energy.rf.BaseRFAxe;

public class ItemRFAxe
extends BaseRFAxe {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150376_bx, Blocks.field_150373_bw, Blocks.field_150486_ae, Blocks.field_150468_ap, Blocks.field_150462_ai, Blocks.field_150415_aT, Blocks.field_180405_aT, Blocks.field_180404_aQ, Blocks.field_180406_aS, Blocks.field_180403_aR, Blocks.field_180407_aO, Blocks.field_180408_aP, Blocks.field_180387_bt, Blocks.field_180392_bq, Blocks.field_180385_bs, Blocks.field_180386_br, Blocks.field_180390_bo, Blocks.field_180391_bp, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150342_X, Blocks.field_185766_cS, Blocks.field_185765_cR, Blocks.field_150323_B, Blocks.field_150423_aK, Blocks.field_150440_ba, Blocks.field_150344_f, Blocks.field_150452_aw, Blocks.field_150400_ck, Blocks.field_150487_bG, Blocks.field_150485_bF, Blocks.field_150401_cl, Blocks.field_150481_bH, Blocks.field_150476_ad});

    public ItemRFAxe() {
        super(Item.ToolMaterial.DIAMOND, "redstone_flux_axe", EFFECTIVE_ON, APConfig.maxCapacityAxe, APConfig.inputAxe, APConfig.outputAxe);
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77656_e(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        this.extractEnergy(stack, APConfig.outputAxe, false);
        return true;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack powered = new ItemStack(itemIn, 1, 1);
        ItemStack unpowered = new ItemStack(itemIn);
        this.poweredItem(powered);
        subItems.add(powered);
        this.createPoweredStack(powered, false);
        subItems.add(unpowered);
    }

    private int poweredItem(ItemStack itemStack) {
        return this.receiveEnergy(itemStack, this.getMaxEnergyStored(itemStack), false);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77952_i() == 1) {
            this.createPoweredStack(stack, false);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_150897_b(IBlockState state) {
        return Items.field_151056_x.func_150897_b(state);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.getEnergyStored(stack) < APConfig.outputAxe) {
            return 0.5f;
        }
        if (Items.field_151053_p.func_150893_a(stack, state) > 1.0f) {
            return 5.5f;
        }
        return super.func_150893_a(stack, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.createTooltip(stack, tooltip);
    }

    private int createPoweredStack(ItemStack container, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", APConfig.maxCapacityAxe);
        }
        return APConfig.maxCapacityAxe;
    }

    private void createTooltip(ItemStack stack, List<String> tooltip) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"", (Object[])new Object[0]) + this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack) + I18n.func_135052_a((String)" RF", (Object[])new Object[0]));
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tooltip.rf.cost.tool", (Object[])new Object[]{Integer.toString(this.getMaxReceive(stack))}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.rf.showinfo", (Object[])new Object[]{TextFormatting.DARK_RED, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }
}

