/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.util;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.thedragonteam.armorplus.registry.ModPotions;

public class PotionUtils {
    public static void addPotion(EntityLivingBase entity, String potion, int duration, int amplifier, boolean ambientIn, boolean showParticlesIn) {
        if (potion != null) {
            entity.func_70690_d(new PotionEffect(PotionUtils.getPotion(potion), duration, amplifier, ambientIn, showParticlesIn));
        }
    }

    public static void addPotion(EntityLivingBase entity, Potion potion, int duration, int amplifier, boolean ambientIn, boolean showParticlesIn) {
        if (potion != null) {
            entity.func_70690_d(new PotionEffect(potion, duration, amplifier, ambientIn, showParticlesIn));
        }
    }

    public static void addPotion(EntityLivingBase entity, String potion, int duration, int amplifier, boolean ambientIn, PotionType potionType) {
        if (potion != null) {
            PotionUtils.addPotion(entity, PotionUtils.getPotion(potion), duration, amplifier, ambientIn, potionType.hasParticles());
        }
    }

    public static void addPotion(EntityLivingBase entity, Potion potion, int duration, int amplifier, boolean ambientIn, PotionType potionType) {
        if (potion != null) {
            PotionUtils.addPotion(entity, potion, duration, amplifier, ambientIn, potionType.hasParticles());
        }
    }

    public static void addPotion(EntityLivingBase entity, Potion potion, int duration, int amplifier, PotionType potionType) {
        if (potion != null) {
            PotionUtils.addPotion(entity, potion, duration, amplifier, false, potionType.hasParticles());
        }
    }

    public static void addPotion(EntityLivingBase entity, String potion, int amplifier, PotionType potionType) {
        if (potion != null) {
            PotionUtils.addPotion(entity, PotionUtils.getPotion(potion), 240, amplifier, false, potionType.hasParticles());
        }
    }

    public static void addPotion(EntityLivingBase entity, Potion potion, int amplifier, PotionType potionType) {
        if (potion != null) {
            PotionUtils.addPotion(entity, potion, 240, amplifier, false, potionType.hasParticles());
        }
    }

    public static void removePotion(EntityLivingBase entity, String potion) {
        entity.func_184589_d(potion != null ? PotionUtils.getPotion(potion) : ModPotions.EMPTY);
    }

    public static void removePotion(EntityLivingBase entity, Potion potion) {
        entity.func_184589_d(potion != null ? potion : ModPotions.EMPTY);
    }

    public static String localizePotion(String resourceLocation) {
        return PotionUtils.getPotion(resourceLocation) != null ? I18n.func_74838_a((String)(PotionUtils.getPotion(resourceLocation).func_76393_a() + ".name")).trim() : "";
    }

    public static Potion getPotion(String resourceLocation) {
        return Potion.func_180142_b((String)resourceLocation) != null ? Potion.func_180142_b((String)resourceLocation) : ModPotions.EMPTY;
    }

    public static enum PotionType {
        GOOD(false),
        BAD(true);

        private final boolean showParticles;

        private PotionType(boolean showParticlesIn) {
            this.showParticles = showParticlesIn;
        }

        public boolean hasParticles() {
            return this.showParticles;
        }
    }
}

