/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.worldgen.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class StructureCastle
extends WorldGenerator {
    private final int[][] stoneBrickTowerPos = new int[][]{{0, 4, 0}, {6, 4, 0}, {0, 4, 6}, {6, 4, 6}};
    private final int[][] stoneBrickPos = new int[][]{{0, -1, 0}, {1, -1, 0}, {2, -1, 0}, {3, -1, 0}, {4, -1, 0}, {5, -1, 0}, {6, -1, 0}, {0, -1, 1}, {1, -1, 1}, {2, -1, 1}, {3, -1, 1}, {4, -1, 1}, {5, -1, 1}, {6, -1, 1}, {0, -1, 2}, {1, -1, 2}, {2, -1, 2}, {3, -1, 2}, {4, -1, 2}, {5, -1, 2}, {6, -1, 2}, {0, -1, 3}, {1, -1, 3}, {2, -1, 3}, {3, -1, 3}, {4, -1, 3}, {5, -1, 3}, {6, -1, 3}, {0, -1, 4}, {1, -1, 4}, {2, -1, 4}, {3, -1, 4}, {4, -1, 4}, {5, -1, 4}, {6, -1, 4}, {0, -1, 5}, {1, -1, 5}, {2, -1, 5}, {3, -1, 5}, {4, -1, 5}, {5, -1, 5}, {6, -1, 5}, {0, -1, 6}, {1, -1, 6}, {2, -1, 6}, {3, -1, 6}, {4, -1, 6}, {5, -1, 6}, {6, -1, 6}, {0, 3, 0}, {1, 3, 0}, {2, 3, 0}, {3, 3, 0}, {4, 3, 0}, {5, 3, 0}, {6, 3, 0}, {0, 3, 6}, {1, 3, 6}, {2, 3, 6}, {3, 3, 6}, {4, 3, 6}, {5, 3, 6}, {6, 3, 6}, {0, 3, 1}, {0, 3, 2}, {0, 3, 3}, {0, 3, 4}, {0, 3, 5}, {6, 3, 1}, {6, 3, 2}, {6, 3, 3}, {6, 3, 4}, {6, 3, 5}};
    private final int[] doorBottomPos = new int[]{3, 0, 0};
    private final int[] doorTopPos = new int[]{3, 1, 0};
    private final int[] chestPos = new int[]{1, 0, 3};
    private final int[] glowstonePos = new int[]{3, -1, 3};
    private final int[][] lavaPos = new int[][]{{-1, -1, -1}, {-1, -1, -2}, {-2, -1, -1}, {-1, -1, 0}, {-2, -1, 0}, {7, -1, 0}, {8, -1, 0}, {-1, -1, 1}, {-2, -1, 1}, {7, -1, 1}, {8, -1, 1}, {-1, -1, 2}, {-2, -1, 2}, {7, -1, 2}, {8, -1, 2}, {-1, -1, 3}, {-2, -1, 3}, {7, -1, 3}, {8, -1, 3}, {-1, -1, 4}, {-2, -1, 4}, {7, -1, 4}, {8, -1, 4}, {-1, -1, 5}, {-2, -1, 5}, {7, -1, 5}, {8, -1, 5}, {-1, -1, 6}, {-2, -1, 6}, {7, -1, 6}, {8, -1, 6}, {-1, -1, 7}, {-2, -1, 7}, {7, -1, 7}, {8, -1, 7}, {-1, -1, 8}, {0, -1, -1}, {0, -1, -2}, {0, -1, 7}, {0, -1, 8}, {1, -1, -1}, {1, -1, -2}, {1, -1, 7}, {1, -1, 8}, {2, -1, -1}, {2, -1, -2}, {2, -1, 7}, {2, -1, 8}, {3, -1, -1}, {3, -1, -2}, {3, -1, 7}, {3, -1, 8}, {4, -1, -1}, {4, -1, -2}, {4, -1, 7}, {4, -1, 8}, {5, -1, -1}, {5, -1, -2}, {5, -1, 7}, {5, -1, 8}, {6, -1, -1}, {6, -1, -2}, {6, -1, 7}, {6, -1, 8}, {7, -1, -1}, {7, -1, -2}, {7, -1, 7}, {7, -1, 8}, {8, -1, -1}};
    private final int[][] stonePos = new int[][]{{-1, -2, -1}, {-1, -2, -2}, {-2, -2, -1}, {-1, -2, 0}, {-2, -2, 0}, {7, -2, 0}, {8, -2, 0}, {-1, -2, 1}, {-2, -2, 1}, {7, -2, 1}, {8, -2, 1}, {-1, -2, 2}, {-2, -2, 2}, {7, -2, 2}, {8, -2, 2}, {-1, -2, 3}, {-2, -2, 3}, {7, -2, 3}, {8, -2, 3}, {-1, -2, 4}, {-2, -2, 4}, {7, -2, 4}, {8, -2, 4}, {-1, -2, 5}, {-2, -2, 5}, {7, -2, 5}, {8, -2, 5}, {-1, -2, 6}, {-2, -2, 6}, {7, -2, 6}, {8, -2, 6}, {-1, -2, 7}, {-2, -2, 7}, {7, -2, 7}, {8, -2, 7}, {-1, -2, 8}, {0, -2, -1}, {0, -2, -2}, {0, -2, 7}, {0, -2, 8}, {1, -2, -1}, {1, -2, -2}, {1, -2, 7}, {1, -2, 8}, {2, -2, -1}, {2, -2, -2}, {2, -2, 7}, {2, -2, 8}, {3, -2, -1}, {3, -2, -2}, {3, -2, 7}, {3, -2, 8}, {4, -2, -1}, {4, -2, -2}, {4, -2, 7}, {4, -2, 8}, {5, -2, -1}, {5, -2, -2}, {5, -2, 7}, {5, -2, 8}, {6, -2, -1}, {6, -2, -2}, {6, -2, 7}, {6, -2, 8}, {7, -2, -1}, {7, -2, -2}, {7, -2, 7}, {7, -2, 8}, {8, -2, -1}, {-2, -1, -2}, {-3, -1, -2}, {-2, -1, -3}, {8, -1, -2}, {9, -1, -2}, {8, -1, -3}, {-2, -1, 8}, {-3, -1, 8}, {-2, -1, 9}, {8, -1, 8}, {8, -1, 9}, {9, -1, 8}, {-1, -1, -3}, {0, -1, -3}, {1, -1, -3}, {2, -1, -3}, {3, -1, -3}, {4, -1, -3}, {5, -1, -3}, {6, -1, -3}, {7, -1, -3}, {-3, -1, -1}, {-3, -1, 0}, {-3, -1, 1}, {-3, -1, 2}, {-3, -1, 3}, {-3, -1, 4}, {-3, -1, 5}, {-3, -1, 6}, {-3, -1, 7}, {9, -1, -1}, {9, -1, 0}, {9, -1, 1}, {9, -1, 2}, {9, -1, 3}, {9, -1, 4}, {9, -1, 5}, {9, -1, 6}, {9, -1, 7}, {-1, -1, 9}, {0, -1, 9}, {1, -1, 9}, {2, -1, 9}, {3, -1, 9}, {4, -1, 9}, {5, -1, 9}, {6, -1, 9}, {7, -1, 9}};
    private final int[][] stoneFencePos = new int[][]{{-2, 0, -2}, {-3, 0, -2}, {-2, 0, -3}, {8, 0, -2}, {9, 0, -2}, {8, 0, -3}, {-2, 0, 8}, {-3, 0, 8}, {-2, 0, 9}, {8, 0, 8}, {8, 0, 9}, {9, 0, 8}, {-1, 0, -3}, {0, 0, -3}, {1, 0, -3}, {2, 0, -3}, {3, 0, -3}, {4, 0, -3}, {5, 0, -3}, {6, 0, -3}, {7, 0, -3}, {-3, 0, -1}, {-3, 0, 0}, {-3, 0, 1}, {-3, 0, 2}, {-3, 0, 3}, {-3, 0, 4}, {-3, 0, 5}, {-3, 0, 6}, {-3, 0, 7}, {9, 0, -1}, {9, 0, 0}, {9, 0, 1}, {9, 0, 2}, {9, 0, 3}, {9, 0, 4}, {9, 0, 5}, {9, 0, 6}, {9, 0, 7}, {-1, 0, 9}, {0, 0, 9}, {1, 0, 9}, {2, 0, 9}, {3, 0, 9}, {4, 0, 9}, {5, 0, 9}, {6, 0, 9}, {7, 0, 9}};

    public boolean func_180709_b(World worldIn, Random rand, BlockPos corner) {
        if (this.canSpawnHere(worldIn, corner)) {
            int x;
            int[] stoneBrickLeft;
            int z;
            int y;
            IBlockState stoneBrickTower = ModBlocks.stoneBrickTowers[0].func_176223_P();
            IBlockState stoneBrick = ModBlocks.stoneBricks[0].func_176223_P();
            IBlockState doorLower = Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            IBlockState doorUpper = Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            IBlockState chest = Blocks.field_150486_ae.func_176223_P();
            IBlockState glowstone = Blocks.field_150426_aN.func_176223_P();
            IBlockState lava = Blocks.field_150353_l.func_176223_P();
            IBlockState stone = Blocks.field_150417_aV.func_176223_P();
            IBlockState stoneFence = Blocks.field_150463_bK.func_176223_P();
            this.buildLayer(worldIn, corner, this.stoneBrickTowerPos, stoneBrickTower);
            this.buildLayer(worldIn, corner, this.stoneBrickPos, stoneBrick);
            this.buildLayer(worldIn, corner, this.lavaPos, lava);
            this.buildLayer(worldIn, corner, this.stonePos, stone);
            this.buildLayer(worldIn, corner, this.stoneFencePos, stoneFence);
            this.placeBlock(worldIn, corner, this.doorBottomPos, doorLower);
            this.placeBlock(worldIn, corner, this.doorTopPos, doorUpper);
            this.placeBlock(worldIn, corner, this.glowstonePos, glowstone);
            this.placeBlock(worldIn, corner, this.chestPos, chest);
            TileEntity tileentity1 = this.getTileEntity(worldIn, corner, this.chestPos);
            this.placeTileEntity(worldIn, corner, this.chestPos, tileentity1);
            for (y = 0; y <= 2; ++y) {
                z = 1;
                while (z <= 6) {
                    stoneBrickLeft = new int[]{0, y, z++};
                    this.placeBlock(worldIn, corner, stoneBrickLeft, stoneBrick);
                }
            }
            for (y = 0; y <= 2; ++y) {
                z = 1;
                while (z <= 6) {
                    stoneBrickLeft = new int[]{6, y, z++};
                    this.placeBlock(worldIn, corner, stoneBrickLeft, stoneBrick);
                }
            }
            for (y = 0; y <= 2; ++y) {
                x = 1;
                while (x <= 6) {
                    stoneBrickLeft = new int[]{x++, y, 6};
                    this.placeBlock(worldIn, corner, stoneBrickLeft, stoneBrick);
                }
            }
            this.buildWall(worldIn, corner, stoneBrick, 6, 2, 0, 'x');
            this.buildWall(worldIn, corner, stoneBrick, 6, 2, 6, 'x');
            this.buildWall(worldIn, corner, stoneBrick, 6, 2, 0, 'z');
            this.buildWall(worldIn, corner, stoneBrick, 6, 2, 6, 'z');
            for (y = 0; y <= 2; ++y) {
                x = 0;
                while (x <= 6) {
                    stoneBrickLeft = new int[]{x++, y, 0};
                    this.placeBlock(worldIn, corner, stoneBrickLeft, stoneBrick);
                }
            }
            if (tileentity1 instanceof TileEntityChest) {
                ((TileEntityChest)tileentity1).func_189404_a(LootTableList.field_186421_c, rand.nextLong());
            }
            if (APConfig.isDebugMode()) {
                LogHelper.info((Object)("Built a castle starting at " + corner + "!"));
            }
            return true;
        }
        if (APConfig.isDebugMode()) {
            LogHelper.info((Object)("Sorry, can't spawn a castle at " + corner));
        }
        return false;
    }

    private void buildWall(World worldIn, BlockPos corner, IBlockState block, int maxPos, int maxPosY, int posIn, char xz) {
        switch (xz) {
            case 'x': {
                for (int posY = 0; posY <= maxPosY; ++posY) {
                    int pos = 0;
                    while (pos <= maxPos) {
                        int[] stoneBrickLeft = new int[]{pos++, posY, posIn};
                        this.placeBlock(worldIn, corner, stoneBrickLeft, block);
                    }
                }
                break;
            }
            case 'z': {
                for (int posY = 0; posY <= maxPosY; ++posY) {
                    int pos = 0;
                    while (pos <= maxPos) {
                        int[] stoneBrickLeft = new int[]{posIn, posY, pos++};
                        this.placeBlock(worldIn, corner, stoneBrickLeft, block);
                    }
                }
                break;
            }
        }
    }

    private void buildLayer(World world, BlockPos frontLeftCorner, int[][] blockPositions, IBlockState toPlace) {
        for (int[] coord : blockPositions) {
            this.placeBlock(world, frontLeftCorner, coord[0], coord[1], coord[2], toPlace);
        }
    }

    private void placeTileEntity(World world, BlockPos frontLeftCorner, int[] offsets, TileEntity toPlace) {
        this.placeTileEntity(world, frontLeftCorner, offsets[0], offsets[1], offsets[2], toPlace);
    }

    private void placeTileEntity(World world, BlockPos frontLeftCorner, int offsetX, int offsetY, int offsetZ, TileEntity toPlace) {
        BlockPos placePos = frontLeftCorner.func_177982_a(offsetX, offsetY, offsetZ);
        world.func_175690_a(placePos, toPlace);
    }

    private TileEntity getTileEntity(World world, BlockPos frontLeftCorner, int[] offsets) {
        return this.getTileEntity(world, frontLeftCorner, offsets[0], offsets[1], offsets[2]);
    }

    private TileEntity getTileEntity(World world, BlockPos frontLeftCorner, int offsetX, int offsetY, int offsetZ) {
        BlockPos placePos = frontLeftCorner.func_177982_a(offsetX, offsetY, offsetZ);
        return world.func_175625_s(placePos);
    }

    private void placeBlock(World world, BlockPos frontLeftCorner, int[] offsets, IBlockState toPlace) {
        this.placeBlock(world, frontLeftCorner, offsets[0], offsets[1], offsets[2], toPlace);
    }

    private void placeBlock(World world, BlockPos frontLeftCorner, int offsetX, int offsetY, int offsetZ, IBlockState toPlace) {
        BlockPos placePos = frontLeftCorner.func_177982_a(offsetX, offsetY, offsetZ);
        world.func_180501_a(placePos, toPlace, 2);
    }

    private boolean canSpawnHere(World world, BlockPos posAboveGround) {
        boolean corner1Air = this.canReplace(world, posAboveGround);
        boolean corner2Air = this.canReplace(world, posAboveGround.func_177982_a(4, 0, 0));
        boolean corner4Air = this.canReplace(world, posAboveGround.func_177982_a(0, 0, 4));
        boolean corner3Air = this.canReplace(world, posAboveGround.func_177982_a(4, 0, 4));
        return posAboveGround.func_177956_o() > 20 && corner1Air && corner2Air && corner3Air && corner4Air;
    }

    private boolean canReplace(World world, BlockPos pos) {
        Block at = world.func_180495_p(pos).func_177230_c();
        Material material = at.func_149688_o(at.func_176223_P());
        return material.func_76222_j() || material == Material.field_151575_d || material == Material.field_151584_j;
    }
}

