/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.api.crafting.lavainfuser;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class LavaInfuserManager {
    private static final LavaInfuserManager INFUSING_BASE = new LavaInfuserManager();
    private final Map<ItemStack, ItemStack> infusingList = Maps.newHashMap();
    private final Map<ItemStack, Double> experienceList = Maps.newHashMap();

    private LavaInfuserManager() {
        this.addInfusingRecipe(new ItemStack((Item)ModItems.lavaCrystal, 1, 0), ItemStackUtils.getItemStack((Item)ModItems.lavaCrystal, (int)1), 0.1);
        this.addInfusingRecipeForBlock(ModBlocks.compressedObsidian, ItemStackUtils.getItemStack((Block)ModBlocks.lavaInfusedObsidian), 0.2);
    }

    public static LavaInfuserManager getInstance() {
        return INFUSING_BASE;
    }

    public void addInfusingRecipeForBlock(Block input, ItemStack stack, double experience) {
        this.addInfusing(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addInfusing(Item input, ItemStack stack, double experience) {
        this.addInfusingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addInfusing(ItemStack input, ItemStack stack) {
        this.addInfusingRecipe(input, stack, 0.0);
    }

    public void addInfusingRecipe(ItemStack input, ItemStack stack, double experience) {
        if (!this.getSmeltingResult(input).func_190926_b()) {
            LogHelper.INSTANCE.info((Object)("Ignored smelting recipe with conflicting input: " + input + " = " + stack));
            return;
        }
        this.infusingList.put(input, stack);
        this.experienceList.put(stack, experience);
    }

    public void removeRecipe(ItemStack recipe) {
        this.infusingList.remove(recipe);
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        return this.infusingList.entrySet().stream().filter(entry -> this.compareItemStacks(stack, (ItemStack)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(ItemStack.field_190927_a);
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getInfusingList() {
        return this.infusingList;
    }

    public double getSmeltingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        return this.experienceList.entrySet().stream().filter(entry -> this.compareItemStacks(stack, (ItemStack)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(0.0);
    }
}

