/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.armors.base.ItemArmorBase;
import net.thedragonteam.armorplus.registry.APItems;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.registry.ModPotions;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.ToolTipUtils;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;
import org.jetbrains.annotations.NotNull;

public enum APArmorMaterial implements IStringSerializable
{
    COAL(ItemArmorBase.Companion.getCoalArmor(), "coal", ItemStackUtils.getItemStack((Item)Items.field_151044_h).func_77973_b(), ItemStackUtils.getItemStack((Block)Blocks.field_150402_ci).func_77973_b(), TextFormatting.func_96300_b((String)APConfig.coalArmorItemNameColor), APConfig.enableFullCoalArmorEffect, APConfig.coalArmorAddPotionEffect, APConfig.coalArmorEffectLevel, APConfig.enableCoalEffect, "empty"),
    LAPIS(ItemArmorBase.Companion.getLapisArmor(), "lapis", ItemStackUtils.getItemStack((Item)Items.field_151100_aR, (int)4), ItemStackUtils.getItemStack((Block)Blocks.field_150368_y), TextFormatting.func_96300_b((String)APConfig.lapisArmorItemNameColor), APConfig.enableFullLapisArmorEffect, APConfig.lapisArmorAddPotionEffect, APConfig.lapisArmorEffectLevel, APConfig.enableLapisEffect, "empty"),
    REDSTONE(ItemArmorBase.Companion.getRedstoneArmor(), "redstone", ItemStackUtils.getItemStack((Item)Items.field_151137_ax).func_77973_b(), ItemStackUtils.getItemStack((Block)Blocks.field_150451_bX).func_77973_b(), TextFormatting.func_96300_b((String)APConfig.redstoneArmorItemNameColor), APConfig.enableFullRedstoneArmorEffect, APConfig.redstoneArmorAddPotionEffect, APConfig.redstoneArmorEffectLevel, APConfig.enableRedstoneEffect, "empty"),
    EMERALD(ItemArmorBase.Companion.getEmeraldArmor(), "emerald", ItemStackUtils.getItemStack((Item)Items.field_151166_bC).func_77973_b(), ItemStackUtils.getItemStack((Block)Blocks.field_150475_bE).func_77973_b(), TextFormatting.func_96300_b((String)APConfig.emeraldArmorItemNameColor), APConfig.enableFullEmeraldArmorEffect, APConfig.emeraldArmorAddPotionEffect, APConfig.emeraldArmorEffectLevel, APConfig.enableEmeraldEffect, "empty"),
    OBSIDIAN(ItemArmorBase.Companion.getObsidianArmor(), "obsidian", ItemStackUtils.getItemStack((Block)Blocks.field_150343_Z).func_77973_b(), ItemStackUtils.getItemStack((Block)ModBlocks.compressedObsidian).func_77973_b(), TextFormatting.func_96300_b((String)APConfig.obsidianArmorItemNameColor), APConfig.enableFullObsidianArmorEffect, APConfig.obsidianArmorAddPotionEffect, APConfig.obsidianArmorEffectLevel, APConfig.enableObsidianEffect, "empty"),
    LAVA(ItemArmorBase.Companion.getLavaArmor(), "lava", ItemStackUtils.getItemStack((Item)ModItems.lavaCrystal), ItemStackUtils.getItemStack((Item)ModItems.lavaCrystal, (int)1), TextFormatting.func_96300_b((String)APConfig.lavaArmorItemNameColor), APConfig.enableFullLavaArmorEffect, APConfig.lavaArmorAddPotionEffect, APConfig.lavaArmorEffectLevel, APConfig.enableLavaEffect, "empty"){

        @Override
        public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
            if (!APConfig.enableFullLavaArmorEffect) {
                entity.func_70066_B();
                entity.func_110149_m(entity.func_180799_ab() ? 4.0f : 0.0f);
            }
            if (entity.func_70090_H() && !APConfig.enableFullLavaArmorEffect && entity.func_70660_b(MobEffects.field_76427_o) == null) {
                PotionUtils.INSTANCE.addPotion((EntityLivingBase)entity, MobEffects.field_76421_d, 1, PotionUtils.PotionType.BAD);
                itemStack.func_77972_a(1, (EntityLivingBase)entity);
                entity.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
    }
    ,
    GUARDIAN(ItemArmorBase.Companion.getGuardianArmor(), "guardian", ItemStackUtils.getItemStack((Item)ModItems.materials, (int)1), TextFormatting.func_96300_b((String)APConfig.guardianArmorItemNameColor), APConfig.enableFullGuardianArmorEffect, APConfig.guardianArmorAddPotionEffect, APConfig.guardianArmorEffectLevel, APConfig.enableGuardianEffect, "empty"),
    SUPER_STAR(ItemArmorBase.Companion.getSuperStarArmor(), "super_star", ItemStackUtils.getItemStack((Item)ModItems.materials, (int)2), TextFormatting.func_96300_b((String)APConfig.superStarArmorItemNameColor), APConfig.enableFullSuperStarArmorEffect, APConfig.superStarArmorAddPotionEffect, APConfig.superStarArmorEffectLevel, APConfig.enableSuperStarEffect, APConfig.superStarArmorRemovePotionEffect),
    ENDER_DRAGON(ItemArmorBase.Companion.getEnderDragonArmor(), "ender_dragon", ItemStackUtils.getItemStack((Item)ModItems.materials, (int)3), TextFormatting.func_96300_b((String)APConfig.enderDragonArmorItemNameColor), APConfig.enableFullEnderDragonArmorEffect, "empty", 0, APConfig.enableEnderDragonEffect, APConfig.enderDragonArmorRemovePotionEffect){

        @Override
        public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
            ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
            if (APConfig.enableFlightAbility) {
                if (!head.func_190926_b() && head.func_77973_b() == APItems.enderDragonHelmet && !chest.func_190926_b() && chest.func_77973_b() == APItems.enderDragonChestplate && !legs.func_190926_b() && legs.func_77973_b() == APItems.enderDragonLeggings && !feet.func_190926_b() && feet.func_77973_b() == APItems.enderDragonBoots || entity.field_71075_bZ.field_75098_d || entity.func_175149_v()) {
                    entity.field_71075_bZ.field_75101_c = true;
                } else {
                    entity.field_71075_bZ.field_75100_b = false;
                    entity.field_71075_bZ.field_75101_c = false;
                }
            }
            if (PotionUtils.INSTANCE.getPotion(this.getRemovePotionEffect()) != null && PotionUtils.INSTANCE.getPotion(this.getRemovePotionEffect()) != ModPotions.INSTANCE.getEMPTY()) {
                PotionUtils.INSTANCE.removePotion((EntityLivingBase)entity, PotionUtils.INSTANCE.getPotion(this.getRemovePotionEffect()));
            }
        }

        @Override
        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
            KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
            if (ToolTipUtils.isKeyDown()) {
                ToolTipUtils.addToolTipFull(tooltip, "Flight");
            } else {
                ToolTipUtils.showInfo(tooltip, keyBindSneak, this.getFormatting());
            }
        }
    }
    ,
    ARDITE(ItemArmorBase.Companion.getArditeArmor(), "ardite", ItemStackUtils.getTICItemStack((String)"ingots", (int)1), TextFormatting.func_96300_b((String)APConfig.arditeArmorItemNameColor), true, APConfig.arditeArmorAddPotionEffect, APConfig.arditeArmorEffectLevel, new boolean[4], "empty"),
    COBALT(ItemArmorBase.Companion.getCobaltArmor(), "cobalt", ItemStackUtils.getTICItemStack((String)"ingots", (int)0), TextFormatting.func_96300_b((String)APConfig.cobaltArmorItemNameColor), true, APConfig.cobaltArmorAddPotionEffect, APConfig.cobaltArmorEffectLevel, new boolean[4], "empty"),
    MANYULLYN(ItemArmorBase.Companion.getManyullynArmor(), "manyullyn", ItemStackUtils.getTICItemStack((String)"ingots", (int)2), TextFormatting.func_96300_b((String)APConfig.manyullynArmorItemNameColor), true, APConfig.manyullynArmorAddPotionEffect, APConfig.manyullynArmorEffectLevel, new boolean[4], "empty"),
    KNIGHT_SLIME(ItemArmorBase.Companion.getKnightSlimeArmor(), "knight_slime", ItemStackUtils.getTICItemStack((String)"ingots", (int)3), TextFormatting.func_96300_b((String)APConfig.knightSlimeArmorItemNameColor), true, APConfig.knightSlimeArmorAddPotionEffect, APConfig.knightSlimeArmorEffectLevel, new boolean[4], "empty"),
    PIG_IRON(ItemArmorBase.Companion.getPigIronArmor(), "pig_iron", ItemStackUtils.getTICItemStack((String)"ingots", (int)4), TextFormatting.func_96300_b((String)APConfig.pigIronArmorItemNameColor), true, APConfig.pigIronArmorAddPotionEffect, APConfig.pigIronArmorEffectLevel, new boolean[4], "empty"){

        @Override
        public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
            ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
            if (APConfig.enablePigIronArmorEffect && head.func_77973_b() == APItems.pigIronHelmet && chest.func_77973_b() == APItems.pigIronChestplate && legs.func_77973_b() == APItems.pigIronLeggings && feet.func_77973_b() == APItems.pigIronBoots && entity.func_71024_bL().func_75121_c()) {
                PotionUtils.INSTANCE.addPotion((EntityLivingBase)entity, this.getAddPotionEffect(), this.getAddPotionEffectAmplifier(), PotionUtils.PotionType.GOOD);
                head.func_77972_a(1, (EntityLivingBase)entity);
                chest.func_77972_a(1, (EntityLivingBase)entity);
                legs.func_77972_a(1, (EntityLivingBase)entity);
                feet.func_77972_a(1, (EntityLivingBase)entity);
            }
        }
    }
    ,
    SLIME(ItemArmorBase.Companion.getSlimeArmor(), "slime", ItemStackUtils.getItemStack((Item)Items.field_151123_aH), ItemStackUtils.getItemStack((Block)Blocks.field_180399_cE), TextFormatting.func_96300_b((String)APConfig.slimeArmorItemNameColor), APConfig.enableFullSlimeArmorEffect, APConfig.slimeArmorAddPotionEffect, APConfig.slimeArmorEffectLevel, APConfig.enableSlimeEffect, "empty"),
    CHICKEN(ItemArmorBase.Companion.getChickenArmor(), "chicken", Items.field_151008_G, TextFormatting.func_96300_b((String)APConfig.chickenArmorItemNameColor), APConfig.enableFullCoalArmorEffect, APConfig.chickenArmorAddPotionEffect, APConfig.chickenArmorEffectLevel, APConfig.enableChickenEffect, "empty");

    private final ItemArmor.ArmorMaterial armorMaterial;
    private final String name;
    private final Item itemEasy;
    private final Item itemExpert;
    private final TextFormatting formatting;
    private final boolean enableFullArmorEffect;
    private final String addPotionEffect;
    private final int addPotionEffectAmplifier;
    private final String removePotionEffect;
    private boolean[] areEffectsEnabled;

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, Item repairEasyIn, Item repairExpertIn, TextFormatting textFormattingIn, boolean enableFullArmorEffectIn, String addPotionEffectIn, int addPotionEffectInAmplifierIn, boolean[] areEffectsEnabledIn, String removePotionEffectIn) {
        this.armorMaterial = armorMaterialIn;
        this.name = nameIn;
        this.itemEasy = repairEasyIn;
        this.itemExpert = repairExpertIn;
        this.formatting = textFormattingIn;
        this.enableFullArmorEffect = enableFullArmorEffectIn;
        this.addPotionEffect = addPotionEffectIn;
        this.addPotionEffectAmplifier = addPotionEffectInAmplifierIn;
        this.areEffectsEnabled = areEffectsEnabledIn;
        this.removePotionEffect = removePotionEffectIn;
    }

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, ItemStack stackEasy, ItemStack stackExpert, TextFormatting textFormattingIn, boolean enableFullArmorEffectIn, String addPotionEffectIn, int addPotionEffectInAmplifierIn, boolean[] areEffectsEnabledIn, String removePotionEffectIn) {
        this(armorMaterialIn, nameIn, stackEasy.func_77973_b(), stackExpert.func_77973_b(), textFormattingIn, enableFullArmorEffectIn, addPotionEffectIn, addPotionEffectInAmplifierIn, areEffectsEnabledIn, removePotionEffectIn);
    }

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, ItemStack both, TextFormatting textFormattingIn, boolean enableFullArmorEffectIn, String addPotionEffectIn, int addPotionEffectInAmplifierIn, boolean[] areEffectsEnabledIn, String removePotionEffectIn) {
        this(armorMaterialIn, nameIn, both.func_77973_b(), both.func_77973_b(), textFormattingIn, enableFullArmorEffectIn, addPotionEffectIn, addPotionEffectInAmplifierIn, areEffectsEnabledIn, removePotionEffectIn);
    }

    private APArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, Item both, TextFormatting textFormattingIn, boolean enableFullArmorEffectIn, String addPotionEffectIn, int addPotionEffectInAmplifierIn, boolean[] areEffectsEnabledIn, String removePotionEffectIn) {
        this(armorMaterialIn, nameIn, both, both, textFormattingIn, enableFullArmorEffectIn, addPotionEffectIn, addPotionEffectInAmplifierIn, areEffectsEnabledIn, removePotionEffectIn);
    }

    public ItemArmor.ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    @NotNull
    public String func_176610_l() {
        return this.name;
    }

    public Item getItemEasy() {
        return this.itemEasy;
    }

    public Item getItemExpert() {
        return this.itemExpert;
    }

    public TextFormatting getFormatting() {
        return this.formatting;
    }

    public boolean enableFullArmorEffect() {
        return this.enableFullArmorEffect;
    }

    public String getAddPotionEffect() {
        return this.addPotionEffect;
    }

    public int getAddPotionEffectAmplifier() {
        return this.addPotionEffectAmplifier;
    }

    public boolean[] getAreEffectsEnabled() {
        return this.areEffectsEnabled;
    }

    public String getRemovePotionEffect() {
        return this.removePotionEffect;
    }

    public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (ToolTipUtils.isKeyDown()) {
            if (!this.enableFullArmorEffect()) {
                ToolTipUtils.addToolTipPiece(tooltip, PotionUtils.INSTANCE.localizePotion(this.getAddPotionEffect()), this.getAddPotionEffectAmplifier());
            } else {
                ToolTipUtils.addToolTipFull(tooltip, PotionUtils.INSTANCE.localizePotion(this.getAddPotionEffect()), this.getAddPotionEffectAmplifier());
            }
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, this.getFormatting());
        }
    }
}

