/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.blocks.normal;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.thedragonteam.armorplus.blocks.base.BlockBase;
import net.thedragonteam.armorplus.blocks.base.ToolType;
import net.thedragonteam.armorplus.items.materials.LavaCrystal;
import net.thedragonteam.armorplus.registry.ModItems;

public class BlockLavaCrystal
extends BlockBase {
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockLavaCrystal() {
        super(Material.field_151576_e, "block_lava_crystal", 2000.0f, 25.0f, ToolType.PICKAXE, 3, 0.8f);
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        LavaCrystal item = ModItems.lavaCrystal;
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        return IntStream.range(0, count).mapToObj(i -> new ItemStack(item, 1, this.func_180651_a(state))).collect(Collectors.toList());
    }

    public int quantityDropped(IBlockState blockstate, int fortune, @Nonnull Random random) {
        return 1 + random.nextInt(1 + fortune);
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
        return iblockstate;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151645_D;
    }
}

