/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.worldgen;

import com.google.common.base.Predicate;
import java.util.Random;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.registry.ModBlocks;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016JH\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/thedragonteam/armorplus/worldgen/OreGen;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "()V", "lavaCrystalOverworldGenerator", "Lnet/minecraft/world/gen/feature/WorldGenerator;", "lavaCrystalTheEndGenerator", "lavaCrystalTheNetherGenerator", "generate", "", "random", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/chunk/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "runGenerator", "generator", "rand", "chunk_X", "chunk_Z", "chancesToSpawn", "minHeight", "maxHeight", "ArmorPlus - Kotlin-compileKotlin"})
public final class OreGen
implements IWorldGenerator {
    private final WorldGenerator lavaCrystalOverworldGenerator = (WorldGenerator)new WorldGenMinable(ModBlocks.blockLavaCrystal.func_176223_P(), APConfig.lavaCrystalOverworldVeinAmountWorking);
    private final WorldGenerator lavaCrystalTheEndGenerator = (WorldGenerator)new WorldGenMinable(ModBlocks.blockLavaCrystal.func_176223_P(), APConfig.lavaCrystalTheEndVeinAmount, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private final WorldGenerator lavaCrystalTheNetherGenerator = (WorldGenerator)new WorldGenMinable(ModBlocks.blockLavaCrystal.func_176223_P(), APConfig.lavaCrystalTheNetherVeinAmount, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));

    public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkParameterIsNotNull((Object)chunkProvider, (String)"chunkProvider");
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                if (!APConfig.enableLavaCrystalTheEndGen) break;
                this.runGenerator(this.lavaCrystalTheEndGenerator, world, random, chunkX, chunkZ, APConfig.lavaCrystalTheEndRarity, APConfig.lavaCrystalTheEndMinYSpawn, APConfig.lavaCrystalTheEndMaxYSpawn);
                break;
            }
            case 0: {
                if (!APConfig.enableLavaCrystalOverworldGen) break;
                this.runGenerator(this.lavaCrystalOverworldGenerator, world, random, chunkX, chunkZ, APConfig.lavaCrystalOverworldRarityWorkingOne, APConfig.lavaCrystalOverworldMinYSpawn, APConfig.lavaCrystalOverworldMaxYSpawn);
                break;
            }
            case -1: {
                if (!APConfig.enableLavaCrystalTheNetherGen) break;
                this.runGenerator(this.lavaCrystalTheNetherGenerator, world, random, chunkX, chunkZ, APConfig.lavaCrystalTheNetherRarity, APConfig.lavaCrystalTheNetherMinYSpawn, APConfig.lavaCrystalTheNetherMaxYSpawn);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        boolean bl = minHeight >= 0 && maxHeight <= 256 && minHeight <= maxHeight;
        if (_Assertions.ENABLED && !bl) {
            String string = "Illegal Height Arguments for WorldGenerator";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int heightDiff = maxHeight - minHeight + 1;
        int $i$a$1$assert = 0;
        int n = chancesToSpawn - 1;
        if ($i$a$1$assert <= n) {
            while (true) {
                void i;
                int x = chunk_X * 16 + rand.nextInt(16);
                int y = minHeight + rand.nextInt(heightDiff);
                int z = chunk_Z * 16 + rand.nextInt(16);
                BlockPos orePos = new BlockPos(x, y, z);
                generator.func_180709_b(world, rand, orePos);
                if (i == n) break;
                ++i;
            }
        }
    }
}

