/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.api.crafting.workbench;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.thedragonteam.armorplus.api.crafting.workbench.ShapedRecipes;
import net.thedragonteam.armorplus.api.crafting.workbench.ShapelessRecipes;
import net.thedragonteam.armorplus.api.crafting.workbench.recipes.ModItemsRecipes;
import net.thedragonteam.armorplus.api.crafting.workbench.recipes.ModOriginRecipes;
import net.thedragonteam.armorplus.api.crafting.workbench.recipes.ModSpecialMobRecipes;
import net.thedragonteam.armorplus.api.crafting.workbench.recipes.ModWeaponsTierOneRecipes;

public class WorkbenchCraftingManager {
    private static final WorkbenchCraftingManager INSTANCE = new WorkbenchCraftingManager();
    private final List<IRecipe> recipes = Lists.newArrayList();

    public WorkbenchCraftingManager() {
        new ModItemsRecipes().addRecipes(this);
        new ModOriginRecipes().addRecipes(this);
        new ModSpecialMobRecipes().addRecipes(this);
        new ModWeaponsTierOneRecipes().addRecipes(this);
        this.recipes.sort((pCompare1, pCompare2) -> pCompare1 instanceof ShapelessRecipes && pCompare2 instanceof ShapedRecipes ? 1 : (pCompare2 instanceof ShapelessRecipes && pCompare1 instanceof ShapedRecipes ? -1 : (pCompare2.func_77570_a() < pCompare1.func_77570_a() ? -1 : (pCompare2.func_77570_a() > pCompare1.func_77570_a() ? 1 : 0))));
    }

    public static WorkbenchCraftingManager getInstance() {
        return INSTANCE;
    }

    public ShapedRecipes addRecipe(ItemStack stack, Object ... recipeComponents) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring;
            for (String s2 : astring = (String[])recipeComponents[i++]) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = null;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, Short.MAX_VALUE);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }
            map.put(character, itemstack);
            i += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c0 = s.charAt(i1);
            aitemstack[i1] = map.containsKey(Character.valueOf(c0)) ? ((ItemStack)map.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShapedRecipes shapedrecipes = new ShapedRecipes(j, k, aitemstack, stack);
        this.recipes.add(shapedrecipes);
        return shapedrecipes;
    }

    public void addShapelessRecipe(ItemStack stack, Object ... recipeComponents) {
        ArrayList list = Lists.newArrayList();
        for (Object object : recipeComponents) {
            if (object instanceof ItemStack) {
                list.add(((ItemStack)object).func_77946_l());
                continue;
            }
            if (object instanceof Item) {
                list.add(new ItemStack((Item)object));
                continue;
            }
            assert (object instanceof Block) : "Invalid shapeless recipe: unknown type " + object.getClass().getName() + "!";
            list.add(new ItemStack((Block)object));
        }
        this.recipes.add(new ShapelessRecipes(stack, list));
    }

    public void addRecipe(IRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void removeRecipe(IRecipe recipe) {
        this.recipes.remove(recipe);
    }

    @Nullable
    public ItemStack findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        return this.recipes.stream().filter(irecipe -> irecipe.func_77569_a(craftMatrix, worldIn)).findFirst().map(irecipe -> irecipe.func_77572_b(craftMatrix)).orElse(null);
    }

    public ItemStack[] getRemainingItems(InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : this.recipes) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe.func_179532_b(craftMatrix);
        }
        ItemStack[] aitemstack = new ItemStack[craftMatrix.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            aitemstack[i] = craftMatrix.func_70301_a(i);
        }
        return aitemstack;
    }

    public List<IRecipe> getRecipeList() {
        return this.recipes;
    }
}

