/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.energy.rf;

import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.items.base.energy.rf.BaseRFSword;

public class ItemRFSword
extends BaseRFSword {
    private float attackDamage;
    private ItemStack stack;

    public ItemRFSword() {
        super(Item.ToolMaterial.DIAMOND, "redstone_flux_sword", APConfig.maxCapacitySword, APConfig.inputSword, APConfig.outputSword);
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77656_e(0);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack powered = new ItemStack(itemIn, 1, 1);
        ItemStack unpowered = new ItemStack(itemIn);
        this.poweredItem(powered);
        subItems.add(powered);
        this.createPoweredStack(powered, false);
        subItems.add(unpowered);
    }

    private int poweredItem(ItemStack itemStack) {
        return this.receiveEnergy(itemStack, this.getMaxEnergyStored(itemStack), false);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77952_i() == 1) {
            this.createPoweredStack(stack, false);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_150897_b(IBlockState state) {
        return Items.field_151048_u.func_150897_b(state);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        this.extractEnergy(stack, APConfig.outputSword, false);
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.getEnergyStored(stack) < APConfig.outputSword) {
            return 0.5f;
        }
        return Items.field_151041_m.func_150893_a(stack, state) > 1.0f ? 5.5f : super.func_150893_a(stack, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.createTooltip(stack, tooltip);
    }

    private int createPoweredStack(ItemStack container, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", APConfig.maxCapacitySword);
        }
        return APConfig.maxCapacitySword;
    }

    private void createTooltip(ItemStack stack, List<String> tooltip) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"", (Object[])new Object[0]) + this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack) + I18n.func_135052_a((String)" RF", (Object[])new Object[0]));
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tooltip.rf.cost.hit", (Object[])new Object[]{Integer.toString(this.getMaxReceive(stack))}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.rf.showinfo", (Object[])new Object[]{TextFormatting.DARK_RED, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }
}

