/*
 * Decompiled with CFR 0.152.
 */
package sokratis12gr.armorplus.worldgen;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import sokratis12gr.armorplus.registry.ModBlocks;
import sokratis12gr.armorplus.resources.ConfigHandler;

public class OreGen
implements IWorldGenerator {
    public WorldGenerator lavaCrystalGenerator = new WorldGenMinable(ModBlocks.BLOCK_LAVA_CRYSTAL.func_176223_P(), ConfigHandler.lavaCrystalVeinAmount);
    public WorldGenerator steelOreGenerator = new WorldGenMinable(ModBlocks.STEEL_ORE.func_176223_P(), ConfigHandler.steelOreVeinAmount);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                if (ConfigHandler.enableLavaCrystalOverworldGen) {
                    this.runGenerator(this.lavaCrystalGenerator, world, random, chunkX, chunkZ, ConfigHandler.lavaCrystalOverworldRarity, ConfigHandler.lavaCrystalOverworldMinYSpawn, ConfigHandler.lavaCrystalOverworldMaxYSpawn);
                }
                if (!ConfigHandler.enableSteelOreOverworldGen) break;
                this.runGenerator(this.steelOreGenerator, world, random, chunkX, chunkZ, ConfigHandler.steelOreOverworldRarity, ConfigHandler.steelOreOverworldMinYSpawn, ConfigHandler.steelOreOverworldMaxYSpawn);
                break;
            }
            case 1: {
                if (ConfigHandler.enableLavaCrystalTheEndGen) {
                    this.runGenerator(this.lavaCrystalGenerator, world, random, chunkX, chunkZ, ConfigHandler.lavaCrystalTheEndRarity, ConfigHandler.lavaCrystalTheEndMinYSpawn, ConfigHandler.lavaCrystalTheEndMaxYSpawn);
                }
                if (!ConfigHandler.enableSteelOreTheEndGen) break;
                this.runGenerator(this.steelOreGenerator, world, random, chunkX, chunkZ, ConfigHandler.steelOreTheEndRarity, ConfigHandler.steelOreTheEndMinYSpawn, ConfigHandler.steelOreTheEndMaxYSpawn);
                break;
            }
            case -1: {
                if (ConfigHandler.enableLavaCrystalTheNetherGen) {
                    this.runGenerator(this.lavaCrystalGenerator, world, random, chunkX, chunkZ, ConfigHandler.lavaCrystalTheNetherRarity, ConfigHandler.lavaCrystalTheNetherMinYSpawn, ConfigHandler.lavaCrystalTheNetherMaxYSpawn);
                }
                if (!ConfigHandler.enableSteelOreTheNetherGen) break;
                this.runGenerator(this.steelOreGenerator, world, random, chunkX, chunkZ, ConfigHandler.steelOreTheNetherRarity, ConfigHandler.steelOreTheNetherMinYSpawn, ConfigHandler.steelOreTheNetherMaxYSpawn);
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

