/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.handlers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lnet/thedragonteam/thedragonlib/handlers/ZipHelper;", "", "()V", "unzip", "", "zipFile", "Ljava/io/File;", "destination", "TheDragonLib - Kotlin-compileKotlin"})
public final class ZipHelper {
    public static final ZipHelper INSTANCE;

    public final void unzip(@NotNull File zipFile, @NotNull File destination) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        ZipFile zip = new ZipFile(zipFile);
        destination.mkdir();
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        while (zipFileEntries.hasMoreElements()) {
            String currentEntry = zipFileEntries.nextElement().getName();
            File destFile = new File(destination, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (zipFileEntries.nextElement().isDirectory()) continue;
            BufferedInputStream is = new BufferedInputStream(zip.getInputStream(zipFileEntries.nextElement()));
            byte[] data = new byte[2048];
            FileOutputStream fos = new FileOutputStream(destFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
            int currentByte = is.read(data, 0, 2048);
            while (currentByte != -1) {
                dest.write(data, 0, currentByte);
            }
            dest.flush();
            dest.close();
            is.close();
        }
    }

    private ZipHelper() {
        INSTANCE = this;
    }

    static {
        new ZipHelper();
    }
}

