/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.util;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0004J\u001e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u000bJ\u001e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000fJ\u001e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0011J\u001e\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0013J\u001e\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0015J\u001e\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0017J\u001e\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bJ\u0016\u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006'"}, d2={"Lnet/thedragonteam/thedragonlib/util/ItemNBTHelper;", "", "()V", "getBoolean", "", "stack", "Lnet/minecraft/item/ItemStack;", "tag", "", "defaultExpected", "getByte", "", "getCompound", "Lnet/minecraft/nbt/NBTTagCompound;", "getDouble", "", "getFloat", "", "getInteger", "", "getLong", "", "getShort", "", "getString", "setBoolean", "b", "setByte", "setDouble", "d", "setFloat", "f", "setInteger", "i", "setLong", "setShort", "s", "setString", "verifyExistence", "TheDragonLib - Kotlin-compileKotlin"})
public final class ItemNBTHelper {
    public static final ItemNBTHelper INSTANCE;

    @NotNull
    public final NBTTagCompound getCompound(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nBTTagCompound = stack.func_77978_p();
        if (nBTTagCompound == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
        }
        return nBTTagCompound;
    }

    @NotNull
    public final ItemStack setByte(@NotNull ItemStack stack, @NotNull String tag, byte b) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.getCompound(stack).func_74774_a(tag, b);
        return stack;
    }

    @NotNull
    public final ItemStack setBoolean(@NotNull ItemStack stack, @NotNull String tag, boolean b) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.getCompound(stack).func_74757_a(tag, b);
        return stack;
    }

    @NotNull
    public final ItemStack setShort(@NotNull ItemStack stack, @NotNull String tag, short s) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.getCompound(stack).func_74777_a(tag, s);
        return stack;
    }

    @NotNull
    public final ItemStack setInteger(@NotNull ItemStack stack, @NotNull String tag, int i) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.getCompound(stack).func_74768_a(tag, i);
        return stack;
    }

    @NotNull
    public final ItemStack setLong(@NotNull ItemStack stack, @NotNull String tag, long i) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.getCompound(stack).func_74772_a(tag, i);
        return stack;
    }

    @NotNull
    public final ItemStack setFloat(@NotNull ItemStack stack, @NotNull String tag, float f) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.getCompound(stack).func_74776_a(tag, f);
        return stack;
    }

    @NotNull
    public final ItemStack setDouble(@NotNull ItemStack stack, @NotNull String tag, double d) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.getCompound(stack).func_74780_a(tag, d);
        return stack;
    }

    @NotNull
    public final ItemStack setString(@NotNull ItemStack stack, @NotNull String tag, @NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.getCompound(stack).func_74778_a(tag, s);
        return stack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean verifyExistence(@NotNull ItemStack stack, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) return false;
        NBTTagCompound nBTTagCompound = stack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        if (!nBTTagCompound.func_74764_b(tag)) return false;
        return true;
    }

    public final byte getByte(@NotNull ItemStack stack, @NotNull String tag, byte defaultExpected) {
        byte by;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.verifyExistence(stack, tag)) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            by = nBTTagCompound.func_74771_c(tag);
        } else {
            by = defaultExpected;
        }
        return by;
    }

    public final boolean getBoolean(@NotNull ItemStack stack, @NotNull String tag, boolean defaultExpected) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.verifyExistence(stack, tag)) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            bl = nBTTagCompound.func_74767_n(tag);
        } else {
            bl = defaultExpected;
        }
        return bl;
    }

    public final short getShort(@NotNull ItemStack stack, @NotNull String tag, short defaultExpected) {
        short s;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.verifyExistence(stack, tag)) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            s = nBTTagCompound.func_74765_d(tag);
        } else {
            s = defaultExpected;
        }
        return s;
    }

    public final int getInteger(@NotNull ItemStack stack, @NotNull String tag, int defaultExpected) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.verifyExistence(stack, tag)) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            n = nBTTagCompound.func_74762_e(tag);
        } else {
            n = defaultExpected;
        }
        return n;
    }

    public final long getLong(@NotNull ItemStack stack, @NotNull String tag, long defaultExpected) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.verifyExistence(stack, tag)) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            l = nBTTagCompound.func_74763_f(tag);
        } else {
            l = defaultExpected;
        }
        return l;
    }

    public final float getFloat(@NotNull ItemStack stack, @NotNull String tag, float defaultExpected) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.verifyExistence(stack, tag)) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            f = nBTTagCompound.func_74760_g(tag);
        } else {
            f = defaultExpected;
        }
        return f;
    }

    public final double getDouble(@NotNull ItemStack stack, @NotNull String tag, double defaultExpected) {
        double d;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.verifyExistence(stack, tag)) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            d = nBTTagCompound.func_74769_h(tag);
        } else {
            d = defaultExpected;
        }
        return d;
    }

    @NotNull
    public final String getString(@NotNull ItemStack stack, @NotNull String tag, @NotNull String defaultExpected) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)defaultExpected, (String)"defaultExpected");
        if (this.verifyExistence(stack, tag)) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            String string2 = nBTTagCompound.func_74779_i(tag);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stack.tagCompound !!.getString(tag)");
        } else {
            string = defaultExpected;
        }
        return string;
    }

    private ItemNBTHelper() {
        INSTANCE = this;
    }

    static {
        new ItemNBTHelper();
    }
}

