/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.thedragonteam.thedragonlib.lib.Vec3D;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011J&\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010J6\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ&\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010J6\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J\u0016\u0010 \u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010J\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0010J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006*"}, d2={"Lnet/thedragonteam/thedragonlib/util/Utils;", "", "()V", "isConnectedToDedicatedServer", "", "()Z", "determineOrientation", "", "x", "y", "z", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "formatNumber", "", "value", "", "", "getDistanceAtoB", "x1", "z1", "x2", "z2", "y1", "y2", "pos1", "Lnet/thedragonteam/thedragonlib/lib/Vec3D;", "pos2", "getDistanceSq", "getNearestMultiple", "number", "multiple", "round", "multiplier", "toInt", "d", "updateNeabourBlocks", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "TheDragonLib - Kotlin-compileKotlin"})
public final class Utils {
    public static final Utils INSTANCE;

    @NotNull
    public final String formatNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf(value);
        }
        if (value < 1000000.0) {
            return String.valueOf((double)Math.round(value) / 1000.0) + "K";
        }
        if (value < 1.0E9) {
            return String.valueOf((double)Math.round(value / 1000.0) / 1000.0) + "M";
        }
        if (value < 1.0E12) {
            return String.valueOf((double)Math.round(value / 1000000.0) / 1000.0) + "B";
        }
        return String.valueOf((double)Math.round(value / 1.0E9) / 1000.0) + "T";
    }

    @NotNull
    public final String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return String.valueOf((double)Math.round(value) / 1000.0) + "K";
        }
        if (value < 1000000000L) {
            return String.valueOf((double)Math.round(value / 1000L) / 1000.0) + "M";
        }
        if (value < 1000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000L) / 1000.0) + "B";
        }
        if (value < 1000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000L) / 1000.0) + "T";
        }
        if (value < 1000000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000000L) / 1000.0) + "Quad";
        }
        return String.valueOf((double)Math.round(value / 1000000000000000L) / 1000.0) + "Quin";
    }

    public final double getDistanceAtoB(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final double getDistanceAtoB(@NotNull Vec3D pos1, @NotNull Vec3D pos2) {
        Intrinsics.checkParameterIsNotNull((Object)pos1, (String)"pos1");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos2");
        return this.getDistanceAtoB(pos1.getX(), pos1.getY(), pos1.getZ(), pos2.getX(), pos2.getY(), pos2.getZ());
    }

    public final double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public final double getDistanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public final double getDistanceSq(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    public final boolean isConnectedToDedicatedServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() == null;
    }

    public final void updateNeabourBlocks(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
    }

    public final int determineOrientation(int x, int y, int z, @NotNull EntityLivingBase entity) {
        int l;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + 1.82 - entity.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return 0;
            }
            if ((double)y - d0 > 0.0) {
                return 1;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : (l == 3 ? 5 : 0)));
    }

    public final double round(double number, double multiplier) {
        return (double)Math.round(number * multiplier) / multiplier;
    }

    public final int getNearestMultiple(int number, int multiple) {
        int result = number;
        if (number < 0) {
            result *= -1;
        }
        if (result % multiple == 0) {
            return number;
        }
        result = result % multiple < multiple / 2 ? (result -= result % multiple) : (result += multiple - result % multiple);
        if (number < 0) {
            result *= -1;
        }
        return result;
    }

    public final int toInt(double d) {
        return (int)d;
    }

    private Utils() {
        INSTANCE = this;
    }

    static {
        new Utils();
    }
}

