/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.wrappers;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.thedragonteam.thedragonlib.TheDragonLib;
import net.thedragonteam.thedragonlib.blocks.TileTDLBase;
import net.thedragonteam.thedragonlib.network.PacketSyncableObject;
import net.thedragonteam.thedragonlib.util.LogHelper;
import net.thedragonteam.thedragonlib.wrappers.SyncableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0018\u0010\n\u001a\u0004\u0018\u00010\u00038BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\f\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lnet/thedragonteam/thedragonlib/wrappers/SyncableString;", "Lnet/thedragonteam/thedragonlib/wrappers/SyncableObject;", "value", "", "syncInTile", "", "syncInContainer", "updateOnReceived", "(Ljava/lang/String;ZZZ)V", "(Ljava/lang/String;ZZ)V", "lastTickValue", "getLastTickValue", "()Ljava/lang/String;", "getValue", "setValue", "(Ljava/lang/String;)V", "detectAndSendChanges", "", "tile", "Lnet/thedragonteam/thedragonlib/blocks/TileTDLBase;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "forceSync", "fromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "toNBT", "toString", "updateReceived", "packet", "Lnet/thedragonteam/thedragonlib/network/PacketSyncableObject;", "TheDragonLib - Kotlin-compileKotlin"})
public final class SyncableString
extends SyncableObject {
    @NotNull
    private String value;
    private String lastTickValue;

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final void setValue(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.value = string;
    }

    private final String getLastTickValue() {
        return null;
    }

    @Override
    public void detectAndSendChanges(@NotNull TileTDLBase tile, @Nullable EntityPlayer player, boolean forceSync) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)tile), (String)"tile");
        if (Intrinsics.areEqual((Object)this.getLastTickValue(), (Object)this.value) ^ true || forceSync) {
            this.lastTickValue = this.value;
            tile.dirtyBlock();
            EntityPlayer entityPlayer = player;
            if (Intrinsics.areEqual((Object)entityPlayer, null)) {
                TheDragonLib.Companion.getNetwork().sendToAllAround((IMessage)new PacketSyncableObject(tile, this.getIndex(), this.value, this.getUpdateOnReceived()), tile.syncRange());
            } else if (entityPlayer instanceof EntityPlayerMP) {
                TheDragonLib.Companion.getNetwork().sendTo((IMessage)new PacketSyncableObject(tile, this.getIndex(), this.value, this.getUpdateOnReceived()), (EntityPlayerMP)player);
            } else {
                LogHelper.INSTANCE.error("SyncableInt#detectAndSendChanges No valid destination for sync packet!", new Object[0]);
            }
        }
    }

    @Override
    public void updateReceived(@NotNull PacketSyncableObject packet) {
        Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
        if (packet.getDataType() == PacketSyncableObject.Companion.getSTRING_INDEX()) {
            this.value = packet.getStringValue();
        }
    }

    @Override
    public void toNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        compound.func_74778_a("SyncableString" + this.getIndex(), this.value);
    }

    @Override
    public void fromNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        if (compound.func_74764_b("SyncableString" + this.getIndex())) {
            String string = compound.func_74779_i("SyncableString" + this.getIndex());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"compound.getString(\"SyncableString\" + index)");
            this.value = string;
        }
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    public SyncableString(@NotNull String value, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        super(syncInTile, syncInContainer, updateOnReceived);
        this.lastTickValue = value;
        String string = this.getLastTickValue();
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        this.value = string;
    }

    public SyncableString(@NotNull String value, boolean syncInTile, boolean syncInContainer) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        super(syncInTile, syncInContainer, false, 4, null);
        this.lastTickValue = value;
        String string = this.getLastTickValue();
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        this.value = string;
    }
}

