/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.core.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.thedragonteam.core.TheDragonCore;
import net.thedragonteam.core.blocks.TileDCBase;
import net.thedragonteam.core.network.PacketSyncableObject;
import net.thedragonteam.core.util.LogHelper;
import net.thedragonteam.core.wrappers.SyncableObject;

public class SyncableDouble
extends SyncableObject {
    public double value;
    private double lastTickValue;

    public SyncableDouble(double value, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        super(syncInTile, syncInContainer, updateOnReceived);
        this.value = this.lastTickValue = value;
    }

    public SyncableDouble(double value, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.value = this.lastTickValue = value;
    }

    @Override
    public void detectAndSendChanges(TileDCBase tile, EntityPlayer player, boolean forceSync) {
        if (this.lastTickValue != this.value || forceSync) {
            this.lastTickValue = this.value;
            tile.dirtyBlock();
            if (player == null) {
                TheDragonCore.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                TheDragonCore.network.sendTo((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), (EntityPlayerMP)player);
            } else {
                LogHelper.error("SyncableInt#detectAndSendChanges No valid destination for sync packet!");
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 3) {
            this.value = packet.doubleValue;
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        compound.func_74780_a("SyncableDouble" + this.index, this.value);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("SyncableDouble" + this.index)) {
            this.value = compound.func_74769_h("SyncableDouble" + this.index);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

