/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.core.config;

import java.lang.reflect.Field;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.thedragonteam.core.config.ModConfigProperty;
import net.thedragonteam.core.util.LogHelper;

public class ModConfigProcessor {
    private Class configClass;
    private Configuration config;

    public void processConfig(Class configClass, Configuration config) {
        this.configClass = configClass;
        this.config = config;
        for (Field field : configClass.getFields()) {
            if (!field.isAnnotationPresent(ModConfigProperty.class)) continue;
            ModConfigProperty property = field.getAnnotation(ModConfigProperty.class);
            try {
                Object defaultValue = field.get(null);
                Object newValue = ModConfigProcessor.getConfigValue(defaultValue, config, property);
                field.set(null, newValue);
            }
            catch (Exception e) {
                LogHelper.error("Something when wrong while loading config value [" + property.name() + "]");
                e.printStackTrace();
            }
        }
        this.saveConfig();
    }

    public static Object getConfigValue(Object defaultValue, Configuration configuration, ModConfigProperty property) throws Exception {
        if (defaultValue instanceof Boolean) {
            return configuration.get(property.category(), property.name(), ((Boolean)defaultValue).booleanValue(), property.comment()).getBoolean(((Boolean)defaultValue).booleanValue());
        }
        if (defaultValue instanceof boolean[]) {
            return configuration.get(property.category(), property.name(), (boolean[])defaultValue, property.comment()).getBooleanList();
        }
        if (defaultValue instanceof Double) {
            return configuration.get(property.category(), property.name(), ((Double)defaultValue).doubleValue(), property.comment()).getDouble(((Double)defaultValue).doubleValue());
        }
        if (defaultValue instanceof double[]) {
            return configuration.get(property.category(), property.name(), (double[])defaultValue, property.comment()).getDoubleList();
        }
        if (defaultValue instanceof Integer) {
            return configuration.get(property.category(), property.name(), ((Integer)defaultValue).intValue(), property.comment()).getInt(((Integer)defaultValue).intValue());
        }
        if (defaultValue instanceof int[]) {
            return configuration.get(property.category(), property.name(), (int[])defaultValue, property.comment()).getIntList();
        }
        if (defaultValue instanceof String) {
            return configuration.get(property.category(), property.name(), (String)defaultValue, property.comment()).getString();
        }
        if (defaultValue instanceof String[]) {
            return configuration.get(property.category(), property.name(), (String[])defaultValue, property.comment()).getStringList();
        }
        throw new Exception("Config data class is unknown");
    }

    public Property findProperty(String category, String name) {
        if (this.config.getCategory(category) != null) {
            return this.config.getCategory(category).get(name);
        }
        return null;
    }

    public void saveConfig() {
        if (this.config != null && this.config.hasChanged()) {
            this.config.save();
        }
    }
}

