/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.core.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.thedragonteam.core.TheDragonCore;
import net.thedragonteam.core.blocks.TileDCBase;
import net.thedragonteam.core.network.PacketSyncableObject;
import net.thedragonteam.core.wrappers.SyncableObject;

public class SyncableBool
extends SyncableObject {
    public boolean value;
    public boolean lastTickValue;

    public SyncableBool(boolean value, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        super(syncInTile, syncInContainer, updateOnReceived);
        this.value = this.lastTickValue = value;
    }

    public SyncableBool(boolean value, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.value = this.lastTickValue = value;
    }

    @Override
    public void detectAndSendChanges(TileDCBase tile, EntityPlayer player, boolean forceSync) {
        if (this.lastTickValue != this.value || forceSync) {
            this.lastTickValue = this.value;
            tile.dirtyBlock();
            if (player == null) {
                TheDragonCore.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                TheDragonCore.network.sendTo((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), (EntityPlayerMP)player);
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 0) {
            this.value = packet.booleanValue;
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        compound.func_74757_a("SyncableBool" + this.index, this.value);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("SyncableBool" + this.index)) {
            this.value = compound.func_74767_n("SyncableBool" + this.index);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

