/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.thedragonteam.thedragonlib.TheDragonLib;
import net.thedragonteam.thedragonlib.blocks.TileDLBase;
import net.thedragonteam.thedragonlib.lib.Vec3I;
import net.thedragonteam.thedragonlib.network.PacketSyncableObject;
import net.thedragonteam.thedragonlib.util.LogHelper;
import net.thedragonteam.thedragonlib.wrappers.SyncableObject;

public class SyncableVec3I
extends SyncableObject {
    public Vec3I vec;
    private Vec3I lastTickVec;

    public SyncableVec3I(Vec3I vec, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        super(syncInTile, syncInContainer, updateOnReceived);
        this.vec = vec;
        this.lastTickVec = vec;
    }

    public SyncableVec3I(Vec3I vec, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.vec = vec;
        this.lastTickVec = vec;
    }

    @Override
    public void detectAndSendChanges(TileDLBase tile, EntityPlayer player, boolean forceSync) {
        if (!this.vec.equals(this.lastTickVec) || forceSync) {
            this.lastTickVec = this.vec.copy();
            tile.dirtyBlock();
            if (player == null) {
                TheDragonLib.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.vec, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                TheDragonLib.network.sendTo((IMessage)new PacketSyncableObject(tile, this.index, this.vec, this.updateOnReceived), (EntityPlayerMP)player);
            } else {
                LogHelper.error("SyncableInt#detectAndSendChanges No valid destination for sync packet!");
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 7) {
            this.vec = packet.vec3I.copy();
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagInt(this.vec.x));
        list.func_74742_a((NBTBase)new NBTTagInt(this.vec.y));
        list.func_74742_a((NBTBase)new NBTTagInt(this.vec.z));
        compound.func_74782_a("SyncableVec3I" + this.index, (NBTBase)list);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        NBTTagList list;
        if (compound.func_74764_b("SyncableVec3I" + this.index) && (list = compound.func_150295_c("SyncableVec3I" + this.index, 3)).func_74745_c() == 3) {
            this.vec.set(list.func_186858_c(0), list.func_186858_c(1), list.func_186858_c(2));
        }
    }

    public String toString() {
        return this.vec.toString();
    }
}

