/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.asm;

import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import net.silentchaos512.scalinghealth.asm.SHAsmConfig;
import net.silentchaos512.scalinghealth.asm.SHLoadingPlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SHClassTransformer
implements IClassTransformer {
    static final String[] classesToTransform = new String[]{"net.minecraft.entity.SharedMonsterAttributes"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        int index = Arrays.asList(classesToTransform).indexOf(transformedName);
        return index != -1 ? this.transform(index, basicClass, SHLoadingPlugin.isObf) : basicClass;
    }

    private byte[] transform(int index, byte[] basicClass, boolean isObf) {
        FMLLog.info((String)("[Scaling Health] Transforming class " + classesToTransform[index]), (Object[])new Object[0]);
        try {
            ClassNode node = new ClassNode();
            ClassReader reader = new ClassReader(basicClass);
            reader.accept((ClassVisitor)node, 0);
            switch (index) {
                case 0: {
                    this.transformSharedMonsterAttributes(node, isObf);
                }
            }
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return basicClass;
        }
    }

    private void transformSharedMonsterAttributes(ClassNode node, boolean isObf) {
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("<clinit>")) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode a = method.instructions.get(i);
                if (a.getOpcode() != 18 || a.getNext().getOpcode() != 183) continue;
                if (a instanceof LdcInsnNode) {
                    LdcInsnNode ldc = (LdcInsnNode)a;
                    if (!(ldc.cst instanceof Double) || (Double)ldc.cst != 1024.0) continue;
                }
                method.instructions.insertBefore(a, (AbstractInsnNode)new LdcInsnNode((Object)SHAsmConfig.getValue("SharedMonsterAttributes.MAX_HEALTH:maxValue")));
                method.instructions.remove(a);
                FMLLog.info((String)"[Scaling Health]   Successfully changed max health maximum!", (Object[])new Object[0]);
                continue block0;
            }
        }
    }
}

