/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.scalinghealth.client.ClientTickHandler;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;

public class DifficultyDisplayHandler
extends Gui {
    public static final ResourceLocation TEXTURE = new ResourceLocation("scalinghealth", "textures/gui/hud.png");
    int lastDifficultyDisplayed = -100;
    int lastAreaDifficultyDisplayed = -100;
    int lastUpdateTime = Integer.MIN_VALUE;
    int currentTime = 0;

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        SHPlayerDataHandler.PlayerData data;
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT || ConfigScalingHealth.DIFFICULTY_MAX <= 0.0f || !ConfigScalingHealth.RENDER_DIFFICULTY_METER) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        SHPlayerDataHandler.PlayerData playerData = data = player != null ? SHPlayerDataHandler.get((EntityPlayer)player) : null;
        if (data == null) {
            return;
        }
        int difficulty = (int)data.getDifficulty();
        int areaDifficulty = MathHelper.func_76125_a((int)((int)ConfigScalingHealth.AREA_DIFFICULTY_MODE.getAreaDifficulty(player.field_70170_p, player.func_180425_c())), (int)0, (int)((int)ConfigScalingHealth.DIFFICULTY_MAX));
        int timeSinceLastUpdate = ClientTickHandler.ticksInGame - this.lastUpdateTime;
        if (difficulty != this.lastDifficultyDisplayed) {
            this.lastDifficultyDisplayed = difficulty;
            this.lastUpdateTime = ClientTickHandler.ticksInGame;
        }
        if (areaDifficulty < this.lastAreaDifficultyDisplayed - 10 || areaDifficulty > this.lastAreaDifficultyDisplayed + 10 && timeSinceLastUpdate > 1200) {
            this.lastAreaDifficultyDisplayed = areaDifficulty;
            this.lastUpdateTime = ClientTickHandler.ticksInGame;
        }
        this.currentTime = ClientTickHandler.ticksInGame;
        if (ConfigScalingHealth.RENDER_DIFFICULTY_METER_ALWAYS || this.currentTime - this.lastUpdateTime < ConfigScalingHealth.DIFFICULTY_METER_DISPLAY_TIME) {
            GlStateManager.func_179147_l();
            mc.field_71446_o.func_110577_a(TEXTURE);
            GlStateManager.func_179094_E();
            int posX = 5;
            int posY = height - 30;
            this.drawTexturedModalRect(posX, posY, 192, 0, 64, 12, 0xFFFFFF);
            int barLength = (int)((float)(60 * areaDifficulty) / ConfigScalingHealth.DIFFICULTY_MAX);
            this.drawTexturedModalRect(posX + 2, posY + 2, 194, 14, barLength, 6, 0xFFFFFF);
            barLength = (int)((float)(60 * difficulty) / ConfigScalingHealth.DIFFICULTY_MAX);
            this.drawTexturedModalRect(posX + 2, posY + 8, 194, 20, barLength, 2, 0xFFFFFF);
            float textScale = 0.6f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)1.0f);
            mc.field_71466_p.func_175063_a("DIFFICULTY", (float)posX / textScale + 4.0f, (float)posY / textScale - 9.0f, 0xFFFFFF);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
        }
    }

    protected void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        this.func_73729_b(x, y, textureX, textureY, width, height);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

