/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;

public class PlayerBonusRegenHandler {
    public static PlayerBonusRegenHandler INSTANCE = new PlayerBonusRegenHandler();
    private Map<String, Integer> timers = new HashMap<String, Integer>();

    public int getTimerForPlayer(EntityPlayer player) {
        if (player == null || !this.timers.containsKey(player.func_70005_c_())) {
            return -1;
        }
        return this.timers.get(player.func_70005_c_());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int foodLevel;
        boolean foodLevelOk;
        if (event.side == Side.CLIENT || !ConfigScalingHealth.ENABLE_BONUS_HEALTH_REGEN) {
            return;
        }
        EntityPlayer player = event.player;
        String name = player.func_70005_c_();
        if (!this.timers.containsKey(name)) {
            this.timers.put(name, ConfigScalingHealth.BONUS_HEALTH_REGEN_INITIAL_DELAY);
        }
        boolean bl = foodLevelOk = (foodLevel = player.func_71024_bL().func_75116_a()) >= ConfigScalingHealth.BONUS_HEALTH_REGEN_MIN_FOOD && foodLevel <= ConfigScalingHealth.BONUS_HEALTH_REGEN_MAX_FOOD;
        if (player.func_110143_aJ() < player.func_110138_aP() && foodLevelOk) {
            int timer = this.timers.get(name);
            if (--timer <= 0) {
                player.func_70691_i(1.0f);
                player.func_71020_j(0.025f);
                timer = ConfigScalingHealth.BONUS_HEALTH_REGEN_DELAY;
            }
            this.timers.put(name, timer);
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving.field_70170_p.field_72995_K || !(entityLiving instanceof EntityPlayer)) {
            return;
        }
        this.timers.put(entityLiving.func_70005_c_(), ConfigScalingHealth.BONUS_HEALTH_REGEN_INITIAL_DELAY);
    }
}

